open Syntax

let conjs  : (trm, unit) Hashtbl.t = Hashtbl.create 1000
let axioms : (trm, unit) Hashtbl.t = Hashtbl.create 1000

let register_cj = Utils.mapm_option (fun c -> Hashtbl.add conjs c ())
let register_axs = List.iter (fun a -> Hashtbl.add axioms a ())

let add_training d (cj,axs,processed,refutation) =
  let add m _ =
    if not (Training.possibly_filter axs m)
    then Simple.add_example d (Training.possibly_normalize m) (List.mem m refutation) in
  Hashtbl.iter add processed;
  register_cj cj;
  register_axs axs

let print_terms data =
  let trms = List.sort compare (Utils.hashtbl_keys data) in
  List.iter (fun t -> print_endline (trm_str t)) trms

let print_stats data =
  Hashtbl.iter (fun k (p, n) -> if Hashtbl.mem conjs k then Format.printf "EC: %d %d %s\n%!" p n (trm_str k)) data;
  Hashtbl.iter (fun c _ -> if Hashtbl.mem axioms c then Format.printf "AC: %s\n%!" (trm_str c)) conjs

let _ =
  if Array.length Sys.argv < 2 then begin
    Format.printf "Usage: %s <OUT> [FILE(S)]\n" Sys.argv.(0); exit 1
  end;

  let output = Sys.argv.(1) in

  let data : trm Simple.data = Hashtbl.create 1000 in

  for i = 2 to Array.length Sys.argv - 1 do
    add_training data (Training.load_training_file Sys.argv.(i))
  done;

  (*Simple.print_data trm_str data;*)
  (*print_terms data;*)
  (*print_stats data;*)

  Utils.with_out output (Simple.write_data data);
  Format.printf "Total number of axioms: %d\n%!" (Hashtbl.length axioms);
  Format.printf "Total number of conjectures: %d\n%!" (Hashtbl.length conjs);
  Printf.printf "Wrote %s with %d terms\n%!" output (Hashtbl.length data)
