let term_weight = ref 0.
let simp_weight = ref 1.
let tbayes_weight = ref 1.
let fbayes_weight = ref 1.
let orig_weight = ref 1.

let term_const_weight = ref 2.
let term_variable_weight = ref 1.

let simp_pweight = ref (-1.)
let simp_nweight = ref 1.

let bayes_fweight = ref 1.
let bayes_lweight = ref 10.
let bayes_iweight = ref 2.1
let bayes_rweight = ref 1.

let model_search_timeout = ref 1.

let float_flags =
[ ("TERM_WEIGHT", term_weight)
; ("SIMP_WEIGHT", simp_weight)
; ("TBAYES_WEIGHT", tbayes_weight)
; ("FBAYES_WEIGHT", fbayes_weight)
; ("ORIG_WEIGHT", orig_weight)

; ("TERM_CONST_WEIGHT", term_const_weight)
; ("TERM_VARIABLE_WEIGHT", term_variable_weight)

; ("SIMP_PWEIGHT", simp_pweight)
; ("SIMP_NWEIGHT", simp_nweight)

; ("BAYES_FWEIGHT", bayes_fweight)
; ("BAYES_LWEIGHT", bayes_lweight)
; ("BAYES_IWEIGHT", bayes_iweight)
; ("BAYES_RWEIGHT", bayes_rweight)
; ("MODEL_SEARCH_TIMEOUT", model_search_timeout) (*** number of seconds to search for models before giving up, useful in case some axioms are easy to find models for but others aren't ***)
]

let set_float_flag k v = List.assoc k float_flags := v

let print_float_flags () =
  List.iter (fun (x, y) -> Printf.printf "%s: %f\n" x !y) float_flags
