(*
Experimental TPTP to Isar proof translator.
Nik Sultana, Cambridge University Computer Lab, August 2013

This is a port of the Coq files in ../coq, into Isar.
The contents of this file encode an embedding of Satallax's
calculus into Isabelle/HOL. This embedding is referenced
by the Isar proofs generated by Satallax.

Notes:
- the Satallax rules are formalised in such a way to allow forward
  reasoning, therefore we can name or otherwise refer to each step of
  the reconstruction.
- we can also instantiate and use lemmas (e.g. eq_sym) in the proof,
  without needing to use "insert" or subgoal_tac, and then fiddle with
  formulas within the proof. I am using "note" and "OF" for this.
- i'd prefer not to describe formulas within the proof. but currently
  have to do it, it seems.
- using "obtain .. where" instead of "fix", for skolemisation.
- it seems i can get by without using these rules a lot of the time,
  by using blast/auto/simp instead.
*)

theory Satallax
imports Hilbert_Choice
begin

(*NOTE universe Prop is replaced by type bool*)
type_synonym Prop = bool ("Prop")
type_synonym o = bool ("o")
typedecl i

(*From stttab.v*)

(*Implicit Arguments TImp [X Y]*)
lemma TImp : "(X --> Y) --> ((~X) | Y)"
by blast

(* Implicit Arguments TNAnd [X Y] *)
lemma TNAnd : "(~(X & Y)) --> (~X --> False) --> (~Y --> False) --> False" by blast

(* Implicit Arguments TAnd [X Y] *)
lemmas TAnd = conjE
lemma TAnd1 : "X & Y \<Longrightarrow> X"
by blast
lemma TAnd2 : "X & Y \<Longrightarrow> Y"
by blast

(* Implicit Arguments TOr [X Y] *)
lemma TOr : "(X | Y) --> (X | Y)"
by blast

(* Implicit Arguments TNor [X Y] *)
lemma TNor : "~(X | Y) --> (~X --> ~Y)"
by blast

lemma TNor1 : "~ ((X::bool) | (Y::bool)) --> ~ X" by blast
lemma TNor2 : "~ ((X::bool) | (Y::bool)) --> ~ Y" by blast

(* Implicit Arguments TNegImp [X Y] *)
lemma TNegImp : "\<lbrakk>~(X --> Y); \<lbrakk>X; ~Y\<rbrakk> \<Longrightarrow> R\<rbrakk> \<Longrightarrow> R"
by blast
lemma TNegImp1 : "~(X --> Y) \<Longrightarrow> X"
by blast
lemma TNegImp2 : "~(X --> Y) \<Longrightarrow> ~Y"
by blast

(* Implicit Arguments TAll [X p] ! (X :: Type) (p::X --> Prop). *)
(*NOTE universe Type is replaced by implicit parametric polymorphism*)
lemma TAll : "(! x::'X.  p x) \<Longrightarrow> p y" (*changed this rule to make it easier to use in isabelle*)
by blast

(* Implicit Arguments TNegAll [X p]
! (X :: Type) (p::X --> Prop).  *)
lemma TNegAll : "\<lbrakk>~(! x::'X.  p x); \<And> y::'X. ~p y --> False\<rbrakk> \<Longrightarrow> False"
by blast

(*"proper" elimination rule*)
lemma TNegAll' : "\<lbrakk>~(! x::'X.  p x); \<And> y::'X. ~p y --> R\<rbrakk> \<Longrightarrow> R"
by blast

(* Implicit Arguments TEx [X p]
! (X :: Type) (p::X --> Prop).
*)
lemma TEx[rule_format] : "\<And> P R. \<lbrakk>Ex P; \<And> y. P y \<Longrightarrow> R\<rbrakk> \<Longrightarrow> R" by blast

(* Implicit Arguments TNegEx [X p]
! (X :: Type) (p::X --> Prop).  *)
lemma TNegEx : "~ (? x::'X.  p x) \<Longrightarrow> ~ p y"
by blast

(* Implicit Arguments TBQ [X Y] *)
lemma TBQ : "(X = Y) --> (X --> Y --> False) --> ( (~X) --> (~Y) --> False) --> False"
by blast

(* Implicit Arguments TBE [X Y] *)
(*NOTE <> becomes ~=*)
lemma TBE : "(X ~= Y) --> (X --> ~Y --> False) --> ( ~X --> Y --> False) --> False"
by blast

(* Implicit Arguments TIff [X Y] *)
(*NOTE <--> becomes =*)
lemma TIff : "(X <-> Y) --> (X --> Y --> False) --> ( ~X --> ~Y --> False) --> False"
by blast

(* Implicit Arguments TNIff [X Y] *)
lemma TNIff : "~(X <-> Y) --> (X --> ~Y --> False) --> ( ~X --> Y --> False) --> False"
by blast

(* Implicit Arguments TFQ [Sig Tau s t] *)
lemma TFQ : "(s = t) --> (! x::'Sig.  s x = (t x :: 'Tau))"
by blast

(* Implicit Arguments TFE [Sig Tau s t] *)
lemma TFE : "(s ~= t) --> ~(! x::'Sig.  s x = (t x :: 'Tau))"
by blast

(* Implicit Arguments TCON [Sig s t u v] *)
lemma TCON : "\<lbrakk>((s::'Sig) = t); (u ~= v)\<rbrakk> \<Longrightarrow> ((s ~= u) & (t ~= u)) | ((s ~= v) & (t ~= v))"
by blast

(* Implicit Arguments Ttrans [Sig s t u] *)
lemma Ttrans : "\<And> s t u. (s=t) --> (t=u) --> ((s=u) --> False) --> False" by blast

(* Implicit Arguments TDec [Sig Tau s t p q]
! (Sig Tau:: Type) (s t::Sig) (p q::Sig --> Tau).
*)
lemma TDec : "(p :: 'Sig => 'Tau) s ~= q t --> ((p ~= q) | (s ~= t))"
by blast

(* Implicit Arguments TMat [Sig s t p q]
! (Sig :: Type) (s t::Sig) (p q::Sig --> Prop). *)
lemma TMat : "p s --> ~ q t --> ( (p ~= q) --> False ) --> ( (s ~= t) --> False) --> False"
by blast

(*NOTE in this world, SType is a type. Since the arguments aren't implicit, we'll make sure to instantiate them explicitly during the proof
! (A::SType) (p::A-->Prop).
*)
(*NOTE use Eps instead of Sepsilon*)
lemma TSeps : "((p :: 'A => Prop) (Eps p) --> False) --> (! x.  ~ p x)"
by (blast intro: someI)

(*(A::SType) *)
lemma TSeps' : "! (eps:: ('A=>Prop)=>'A) (p::'A=>Prop).  (! (q::'A=>Prop) (y::'A).  q y --> q (eps q)) --> (p (eps p) --> False) --> (! x.  ~ p x)"
by (blast intro: someI)

(*(A::SType) *)
lemma TSeps'' : "! (eps:: ('A=>Prop)=>'A) (p::'A=>Prop).   (! (q::'A=>Prop).  ~ (! (y::'A). ~ q y) --> q (eps q)) --> (p (eps p) --> False) --> (! x.  ~ p x)"
by (blast intro: someI)

(* (A::SType)  *)
lemma TSeps''' : "! (eps:: ('A=>Prop)=>'A) (p::'A=>Prop).   (! (q::'A=>Prop).  (? y::'A.  q y) --> q (eps q)) --> (p (eps p) --> False) --> (! x.  ~ p x)"
by (blast intro: someI)


(*Lemmas outside Satallax's calculus*)

lemma eq_ind_r:
  shows "! (x :: 'ty1_) (P :: 'ty1_ => Prop). (P x) --> (! y . y = x --> (P y))" by blast

lemma eq_ind:
  shows "! (x :: 'ty1_) (P :: 'ty1_ => Prop). (P x) --> (! y . x = y --> (P y))" by blast


(*From stt.v*)

(* Implicit Arguments prop_ext [A B]. *)
lemma prop_ext : "((A :: o) = B) --> (A = B)" by blast

(* Implicit Arguments eq_ind_l [A x y]. *)
lemma eq_ind_l:
  shows "! (P :: 'ty1_ => Prop). (P x) --> (x = y --> (P y))" by blast

(*** Two variants of transitivity of equality. ***)
lemma eq_trans2 : "! x y (z :: 'A). x = y --> z = y --> x = z"  by blast

lemma eq_trans3 : "! x y (z :: 'A). y = x --> y = z --> x = z"  by blast


(*** Logical Identities ***)

lemma eq_neg_neg_id : "(% x :: Prop. ~~x) = (% x :: Prop. x)" by blast
lemma eq_true : "True = (~ False)" by blast
lemma eq_and_nor : "(op &) = (% x (y :: Prop). ~(~x | ~y))" by blast
lemma eq_or_nand : "(op |) = (% x (y :: Prop). ~(~x & ~y))" by blast
lemma eq_or_imp : "(op |) = (% x (y :: Prop). (~ x) --> y)" by blast
lemma eq_and_imp : "(op &) = (% x (y :: Prop). ~ (x --> (~ y)))" by blast
lemma eq_imp_or : "(% x (y :: Prop). (x --> y)) = (% x (y :: Prop). ((~x) | y))" by blast

syntax
  "=" :: "[bool, bool] => bool"  ("<->" 50)

lemma eq_iff : "(% s t. s <-> t) = (% s t. s = t)" by blast
(* Implicit Arguments eq_sym_eq [sig]. *)
lemma eq_sym_eq : "(% s (t :: 'sig). s = t) = (% s (t :: 'sig). t = s)" by blast
(* Implicit Arguments eq_forall_nexists [A]. *)
lemma eq_forall_nexists : "(% (f :: 'A => Prop). ! x. f x) = (% (f :: 'A => Prop). ~ (? x. ~f x))" by blast
(* Implicit Arguments eq_exists_nforall [A]. *)
lemma eq_exists_nforall : "(% (f :: 'A => Prop). ? x. f x) = (% (f :: 'A => Prop). ~ (! x. ~ f x))" by blast
(* Implicit Arguments eq_leib1 [A]. *)
lemma eq_leib1 : "(% s (t :: 'A). ! (p :: 'A => Prop). (p s --> p t)) = (% s (t :: 'A ). s = t)"
  apply (rule ext)
  apply (rule ext)
  apply (rule iffI)
  defer
  apply simp
  apply (erule_tac x = "% z. s = z" in allE)
  apply blast
  done
(* Implicit Arguments eq_leib2 [A]. *)
lemma eq_leib2 : "(% s (t :: 'A). ! (p :: 'A => Prop). (~ p s) --> ~ p t) = (% s (t :: 'A ). s = t)"
  apply (rule ext)
  apply (rule ext)
  apply (rule iffI)
  defer
  apply simp
  apply (erule_tac x = "% z. t = z" in allE)
  apply blast
  done
(* Implicit Arguments eq_leib3 [A]. *)
lemma eq_leib3 : "(% s (t :: 'A). ! (r :: 'A => 'A => Prop). (! x. r x x) --> r s t) = (% s (t :: 'A). s = t)"
  apply (rule ext)
  apply (rule ext)
  apply (rule iffI)
  defer
  apply simp
  apply (erule_tac x = "op =" in allE)
  apply (erule mp)
  apply (rule allI)
  apply (rule refl)
  done
(* Implicit Arguments eq_leib4 [A]. *)
lemma eq_leib4 : "(% s (t :: 'A). ! (r :: 'A => 'A => Prop). (~ r s t) --> ~ (! x. r x x) ) = (% s (t :: 'A). s = t)"
  apply (rule ext)
  apply (rule ext)
  apply (rule iffI)
  defer
  apply blast
  apply (erule_tac x = "op =" in allE)
  apply blast
  done

(*** eta ***)
(* Implicit Arguments eq_eta [A B]. *)
lemma eq_eta : "(% (f :: 'A => 'B) (x :: 'A). f x) = (% (f :: 'A => 'B). f)" by blast


(*from Coq's library*)
lemma eq_sym : "! x y. (x :: 'ty1_) = y --> y = x" by blast

end