--------------------------------------------------------------------------------

Satallax 3.2
============

M. Färber  
Universität Innsbruck, Austria


Introduction
------------

Satallax 3.2 [Bro12] is an automated theorem prover for higher-order
logic. The particular form of higher-order logic supported by Satallax
is Church's simple type theory with extensionality and choice
operators. The SAT solver MiniSat [ES04] is responsible for much of
the proof search. The theoretical basis of search is a complete ground
tableau calculus for higher-order logic [BS10] with a choice operator
[BB11]. Problems are given in the THF format.


Proof search
------------

A branch is formed from the axioms of the problem and the negation of the conjecture (if any is given). From this point on, Satallax tries to determine unsatisfiability or satisfiability of this branch. Satallax progressively generates higher-order formulae and corresponding propositional clauses [Bro13]. These formulae and propositional clauses correspond to instances of the tableau rules. Satallax uses the SAT solver MiniSat to test the current set of propositional clauses for unsatisfiability. If the clauses are unsatisfiable, then the original branch is unsatisfiable. Optionally, Satallax generates first-order formulae in addition to the propositional clauses. If this option is used, then Satallax periodically calls the first-order theorem prover E [Sch13] to test for first-order unsatisfiability. If the set of first-order formulae is unsatisfiable, then the original branch is unsatisfiable. Upon request, Satallax attempts to reconstruct a proof which can be output in the TSTP format. The proof reconstruction has been significantly changed since Satallax 3.0 in order to make proof reconstruction more efficient and thus less likely to fail within the time constraints.


Strategies
----------

There are about 150 flags that control the order in which formulae and instantiation terms are considered and propositional clauses are generated. Other flags activate some optional extensions to the basic proof procedure (such as whether or not to call the theorem prover E). A collection of flag settings is called a mode. Approximately 500 modes have been defined and tested so far. A strategy schedule is an ordered collection of modes with information about how much time the mode should be allotted. Satallax tries each of the modes for a certain amount of time sequentially. Before deciding on the schedule to use, Satallax parses the problem and determines if it is big enough that a SInE-based premise selection algorithm [HV11] should be used. If SInE is not activated, then Satallax 3.2 uses a strategy schedule consisting of 37 modes. Each mode is tried for time limits ranging from less than a second to just over 1 minute. If SInE is activated, than Satallax is run with a SInE-specific schedule consisting of 20 possible SInE parameter values selecting different premises and some corresponding modes and time limits.


Implementation
--------------

Satallax is implemented in OCaml, making use of the external tools MiniSat (via a foreign function interface) and E.

Satallax is available at: <http://satallaxprover.com>



Expected Competition Performance
--------------------------------

The addition of a SInE-like procedure for premise selection means Satallax should be able to solve some large problems that were previously out of reach. In addition, the changes to the way TSTP proofs are generated should mean that proofs are more likely to be constructed and reported after a proof has been found. We hope that this will be reflected in an improved performance over Satallax 3.0 from last year.


References
----------

Bro12
:   Brown, C.E. (2012),
    **Satallax: An Automated Higher-Order Prover (System Description)**,
    Gramlich, B. and Miller, D. and Sattler, U.,
    *Proceedings of the 6th International Joint Conference on Automated Reasoning*
    (Manchester, United Kingdom),
    pp.111-117,
    Lecture Notes in Artificial Intelligence 7364,
    Springer-Verlag.

ES04
:   Eén, N. and Sörensson, N. (2004),
    **An Extensible SAT-solver**,
    Giunchiglia, E. and Tacchella, A.,
    *Proceedings of the 6th International Conference on Theory and Applications of Satisfiability Testing*
    (Santa Margherita Ligure, Italy),
    Lecture Notes in Computer Science 2919,
    pp.502-518,
    Springer-Verlag.

BS10
:   Brown, C.E. and Smolka, G. (2010),
    **Analytic Tableaux for Simple Type Theory and its First-Order Fragment**,
    *Logical Methods in Computer Science* 6(2).

BB11
:   Backes, J. and Brown, C.E. (2011),
    **Analytic Tableaux for Higher-Order Logic with Choice**,
    *Journal of Automated Reasoning* 47(4),
    pp.451-479.

Bro13
:   Brown, C.E. (2013),
    **Reducing Higher-Order Theorem Proving to a Sequence of SAT Problems**,
    *Journal of Automated Reasoning* 51(1),
    pp.57-77.

Sch13
:   Schulz, S. (2013)
    **System Description: E 1.8**
    McMillan, K. and Middeldorp, A. and Voronkov, A.
    *Proceedings of the 19th International Conference on Logic for Programming, Artificial Intelligence, and Reasoning*
    (Stellenbosch, South Africa)
    pp.477-483
    Lecture Notes in Computer Science 8312,
    Springer-Verlag
    
HV11
:   Hoder, K. and Voronkov, A. (2011)
    **Sine Qua Non for Large Theory Reasoning**
    Sofronie-Stokkermans, V. and Björner, N.
    *Proceedings of the 23rd International Conference on Automated Deduction*
    (Wroclaw, Poland)
    pp.299-314
    Lecture Notes in Artificial Intelligence 6803,
    Springer-Verlag

--------------------------------------------------------------------------------
