open Tclassify
open Syntax

let add_training_file (classifier : classifier_t) training =
  TClassifier.add_training_exs classifier (training_to_classifier training)

let _ =
  if Array.length Sys.argv < 2 then
    (Format.printf "Usage: %s <OUT> [FILE(S)]\n" Sys.argv.(0); exit 1);

  let output = Sys.argv.(1) in

(*
  let classifier =
    try Utils.with_in output TClassifier.load
    with _ -> TClassifier.empty () in
  let (t, f, l) = TClassifier.get_stats classifier in
  Printf.printf "Read: %i training examples\n%!" t;
  Printf.printf "Read: %i features\n%!" f;
  Printf.printf "Read: %i labels\n%!" l;
*)
  let classifier = TClassifier.empty () in

  for i = 2 to Array.length Sys.argv - 1 do
    add_training_file classifier (Training.load_training_file Sys.argv.(i))
  done;

  TClassifier.write classifier Sys.argv.(1);
  let (t', _, _) = TClassifier.get_stats classifier in
  Printf.printf "Wrote %s with %i training examples\n%!" output t'
