type 'a data = ('a, int * int) Hashtbl.t

let empty n = Hashtbl.create n

let relevance pw nw d x =
  try
    let (pos, neg) = Hashtbl.find d x in
    (*Format.printf "pos = %d, neg = %d (SR)\n%!" pos neg;*)
    let confidence = float_of_int (abs (pos - neg)) /. float_of_int (pos + neg) in
    let sc = confidence *. (pw *. float_of_int pos +. nw *. float_of_int neg) in
(*
    let sc = 2. *. (pw *. float_of_int pos +. nw *. float_of_int neg) /. (float_of_int (pos + neg)) in
*)
(*
    let sc = pw *. float_of_int pos +. nw *. float_of_int neg in
*)
(*
    let sc = pw *. log(float_of_int (pos+1)) +. nw *. log(float_of_int (neg+1)) in
*)
    (* Format.printf "Simple: %f\n%!" sc; *)
    sc
  with Not_found -> 0.

let add_example d x pol =
  let add (pos, neg) = if pol then (pos+1, neg) else (pos, neg+1) in
  Utils.hashtbl_map0 d x add (0,0)

let load_data c = input_value c

let write_data d c = output_value c d

let print_data show =
  Hashtbl.iter (fun k (p, n) -> Format.printf "%d\t%d\t%s\n" p n (show k))
