open Syntax

(******************************************************************************)
(* Simple relevance *)

let simple : (trm Simple.data) ref = ref (Simple.empty 1000)

let load_simple c = simple := Simple.load_data c

let simple_relevance m =
  let r = Simple.relevance !Flags2.simp_pweight !Flags2.simp_nweight !simple m in
  (* Printf.printf "SR %f\n%!" r; *)
  r


(******************************************************************************)
(* Term weight classification *)

let rec term_weight ((cw, vw) as ws) = function
  Name (c, ty) -> cw
| False -> cw | Imp -> cw | Forall ty -> cw | Eq ty -> cw | Choice ty -> cw
| True -> cw | Neg -> cw | Or -> cw | And -> cw | Iff -> cw | Exists ty -> cw
| DB (v, ty) -> vw
| Lam (ty, tm) -> cw +. term_weight ws tm
| Ap (tm1, tm2) -> term_weight ws tm1 +. term_weight ws tm2

let termw_rel m =
  term_weight (!Flags2.term_const_weight, !Flags2.term_variable_weight) m


(******************************************************************************)
(* Combined priority *)

let mult flag f =
  match !flag with
    0. -> 0.
  | 1. -> Lazy.force f
  | w  -> w *. Lazy.force f

let term_priority m n =
  let m = Training.possibly_normalize m in
  let sum =
       mult Flags2.term_weight  (lazy (log (termw_rel m)))
    +. mult Flags2.fbayes_weight (lazy (Fclassify.bayes_rel !Fclassify.processed_ftrs m))
    +. mult Flags2.tbayes_weight (lazy (Tclassify.bayes_rel !Tclassify.axioms m))
    +. mult Flags2.orig_weight (lazy (float_of_int n))
    +. mult Flags2.simp_weight (lazy (simple_relevance m))
  in (* Format.printf "Term priority: %f\n%!" sum; *) int_of_float sum

