--------------------------------------------------------------------------------

Satallax 3.0
============

M. Färber  
Universität Innsbruck, Austria


Introduction
------------

Satallax 3.0 [Bro12] is an automated theorem prover for higher-order logic.
The particular form of higher-order logic supported by Satallax is
Church's simple type theory with extensionality and choice operators.
The SAT solver MiniSat [ES04] is responsible for much of the proof search.
The theoretical basis of search is a complete ground tableau calculus
for higher-order logic [BS10] with a choice operator [BB11].
Problems are given in the THF format.


Proof search
------------

A branch is formed from the axioms of the problem and the
negation of the conjecture (if any is given). From this point on,
Satallax tries to determine unsatisfiability or satisfiability of this branch.
Satallax progressively generates higher-order formulae and
corresponding propositional clauses [Bro13].
These formulae and propositional clauses correspond to instances of the
tableau rules.
Satallax uses the SAT solver MiniSat to test
the current set of propositional clauses for unsatisfiability.
If the clauses are unsatisfiable, then the original branch is unsatisfiable.
Optionally, Satallax generates first-order formulae in addition to
the propositional clauses.
If this option is used, then Satallax periodically calls
the first-order theorem prover E to test for first-order unsatisfiability.
If the set of first-order formulae is unsatisfiable,
then the original branch is unsatisfiable.
Upon request, Satallax attempts to reconstruct a proof
which can be output in the TSTP format.


Strategies
----------

There are about 140 flags that control the order in which formulae and
instantiation terms are considered and propositional clauses are generated.
Other flags activate some optional extensions to the basic proof procedure
(such as whether or not to call the theorem prover E).
A collection of flag settings is called a mode.
Approximately 500 modes have been defined and tested so far.
A strategy schedule is an ordered collection of modes with
information about how much time the mode should be allotted.
Satallax tries each of the modes for a certain amount of time sequentially.
Satallax 3.0 has a strategy schedule consisting of 54 modes (15 of which
make use of E).
Each mode is tried for time limits ranging from less than a second to
about 90 seconds.
The strategy schedule was determined through experimentation using
the THF problems in version 6.3.0 of the TPTP library.


Implementation
--------------

Satallax is implemented in OCaml.
A foreign function interface is used to interact with MiniSat 2.2.0.

Satallax is available at: <http://satallaxprover.com>



Expected Competition Performance
--------------------------------

Since 2015, systems are required to return TSTP proofs.
Previous versions of Satallax could only construct such proofs
if E was not used in the search.
Satallax 3.0 can construct a proof when using E.
Since some problems are (effectively) only solvable when using E,
this should improve performance over last year.
In addition, some support for guiding the search using interpretations
has been implemented. This is also expected to improve performance.


References
----------

Bro12
:   Brown, C.E. (2012),
    **Satallax: An Automated Higher-Order Prover (System Description)**,
    Gramlich, B. and Miller, D. and Sattler, U.,
    *Proceedings of the 6th International Joint Conference on Automated Reasoning*
    (Manchester, United Kingdom),
    pp.111-117,
    Lecture Notes in Artificial Intelligence 7364,
    Springer-Verlag.

ES04
:   Eén, N. and Sörensson, N. (2004),
    **An Extensible SAT-solver**,
    Giunchiglia, E. and Tacchella, A.,
    *Proceedings of the 6th International Conference on Theory and Applications of Satisfiability Testing*
    (Santa Margherita Ligure, Italy),
    Lecture Notes in Computer Science 2919,
    pp.502-518,
    Springer-Verlag.

BS10
:   Brown, C.E. and Smolka, G. (2010),
    **Analytic Tableaux for Simple Type Theory and its First-Order Fragment**,
    *Logical Methods in Computer Science* 6(2).

BB11
:   Backes, J. and Brown, C.E. (2011),
    **Analytic Tableaux for Higher-Order Logic with Choice**,
    *Journal of Automated Reasoning* 47(4),
    pp.451-479.

Bro13
:   Brown, C.E. (2013),
    **Reducing Higher-Order Theorem Proving to a Sequence of SAT Problems**,
    *Journal of Automated Reasoning* 51(1),
    pp.57-77.

--------------------------------------------------------------------------------
