#-------------------------------------------------------------
# Equational specification of a group. This specification does have
# models, i.e. it cannot be refuted (and the prover will note this). 
#
# It uses only unit clauses in infix-equational notation.
#

# There exists a right-neutral element (0).
fof(neutral, axiom, ![X]:f(X,0)=X).

# For each X, there is a right inverse element.
fof(inverse, axiom, ![X]:?[Y]:f(X,Y)=0).

# f is associative.
fof(assoc, axiom, ![X,Y,Z]:f(f(X,Y),Z)=f(X,f(Y,Z))).

# Possible Hypothesis: Right inverse is also left inverse
# fof(rieqli, conjecture, ![X]:?[Y]:(f(X,Y)=0 & f(Y,X)=0)).
fof(rieqli, conjecture, ![X,Y]:(f(X,Y)=0 => f(Y,X)=0)).

# A nother possible hypothesis: Multiplication with inverse element is
# commutative. 
# ~f(a,i(a)) = f(i(a),a).

