open Log

let picomus_prelude myin clauses =
  Printf.fprintf myin "p cnf %d %d\n" (Atom.max_atom ()) (List.length clauses)

let picomus_clauses myin =
  List.iter (fun c -> Printf.fprintf myin "%s 0\n" (String.concat " " (List.map string_of_int c)))

let print_clause_set =
  List.iter (fun cl -> List.iter (fun l -> Printf.printf "%d " l) cl; print_newline ())

let read_picomus_unsat (myout, myin, myerr) =
      let ret = ref [] in
      let cl = ref [] in
      let neg = ref false in
      let atm = ref 0 in
	try
	  (*** This is not the best way to do this.  I'll read in one character at a time, building lit ints, clauses (cl), and pushing clauses onto ret to return ***)
	  while true do
	    let c = input_byte myout in (*** will throw End_of_file when finished ***)
	    if (c = 48) then
	      begin
		if ((!atm) = 0) then (** end of clause **)
		  begin
		    ret := (List.rev (!cl))::!ret;
		    cl := []
		  end
		else
		  atm := 10 * (!atm)
	      end
	    else if ((c > 48) && (c <= 57)) then
	      atm := 10 * (!atm) + (c - 48)
	    else if (c = 45) then (*** negative literal ***)
	      neg := true
	    else (*** otherwise assume this is a blank space ***)
	      begin
		if ((!atm) > 0) then
		  begin
		    if (!neg) then
		      cl := ((-(!atm))::(!cl))
		    else
		      cl := ((!atm)::(!cl));
		    neg := false;
		    atm := 0;
		  end
	      end
	  done;
	  raise End_of_file (*** Unreachable ***)
	with
	| End_of_file ->
	    ignore (Unix.close_process_full (myout,myin,myerr));
	    if (!verbosity > 4) then (print_endline "Minimized Clause Set"; print_clause_set !ret);
	    (!ret)

  
let minimal_unsatisfiable_core clauses =
  if (!verbosity > 4) then Printf.printf "About to call picomus %s\n%!" (!Config.picomus);
  let (myout,myin,myerr) = Unix.open_process_full ((!Config.picomus) ^ " - -") [| |] in
  picomus_prelude myin clauses;
  if (!verbosity > 4) then Printf.printf "About to send clauses to picomus\n%!";
  picomus_clauses myin clauses;
  close_out myin;
  if (!verbosity > 4) then (Printf.printf "About to read result from picomus\n"; flush stdout);
  match (input_line myout) with
  | "s UNSATISFIABLE" ->
    ignore (input_line myout);
    read_picomus_unsat (myout, myin, myerr)
  | _ -> raise (Error.GenericError "strange return from picomus") (*** In case this happens, maybe I should just return all the clauses ***)

