let evaluate (cj, axs, proc, m, n) =
  float_of_int n +. Fclassify.bayes_rel (Fclassify.training_ftrs cj proc) m

let print_score (score, pol) = Format.printf "Score: %f, Pol: %B\n" score pol

let eval_training fp = 
  let (pos, neg) = Utils.with_in fp Training.load_training in
  let ps = List.map (fun ex -> evaluate ex,  true) pos
  and ns = List.map (fun ex -> evaluate ex, false) neg in
  let sorted = List.sort compare (ps @ ns) in
  (*List.iter print_score sorted;*)
  let (_, s) = List.fold_left (fun (negs, sum) (_, pol) ->
    if pol then (negs, sum+negs) else (negs+1, sum)) (0, 0) sorted in
  s

let calc_sum () =
  let sum = ref 0 in
  for i = 2 to Array.length Sys.argv - 1 do
    sum := !sum + eval_training Sys.argv.(i)
  done;
  !sum

let run lw iw rw =
  Flags2.bayes_lweight := lw;
  Flags2.bayes_iweight := iw;
  Flags2.bayes_rweight := rw;
  Format.printf "%d %f %f %f\n%!" (calc_sum ()) lw iw rw

let rec float_seq start step stop =
  if start > stop then []
  else start :: float_seq (start +. step) step stop

let _ =
  if Array.length Sys.argv < 2 then begin
    print_endline "Usage: tune <classifier> [TRAINING(S)]"; exit 1
  end;

  Flags.init_flags ();
  Utils.with_in Sys.argv.(1) Fclassify.load_classifier;

  let lws = [-100.; -10.; -1.; 1.; 10.; 100.]
  (*and iws = float_seq 100. 100. 1000.*)
  and iws = [-100.; -10.; -1.; 1.; 10.; 100.]
  and rws = [-100.; -10.; -1.; 1.; 10.; 100.] in
  List.iter (fun lw -> List.iter (fun iw -> List.iter (fun rw -> run lw iw rw)
    rws ) iws) lws
