open Syntax
open Utils

let filter_fresh_names = true
let normalize_ascending = false
let normalize_fresh_ascending = false
let normalize_fresh_uniform = false
let filter_lemmas = false


let conjectureTerm = function
  Some (_, m, _) -> Some m
| None -> None

let possibly_normalize m =
  if normalize_ascending then snd (normalize_asc m)
  else if normalize_fresh_ascending then snd (normalize_fresh_asc m)
  else if normalize_fresh_uniform then normalize_fresh_uni m
  else m

let possibly_filter axs m =
     (filter_fresh_names && contains_fresh_names m)
  || (filter_lemmas && not (List.mem m axs))


(* Conjecture, axioms, processed terms, refutation terms *)
type training_t = (trm option * trm list * (trm, int) Hashtbl.t * trm list)

let num_processed (_, _, processed, _) = Hashtbl.length processed

let load_training c = (input_value c : training_t)

let save_training (data : training_t) c = output_value c data

let load_training_file f =
  let training : training_t = try Utils.with_in f load_training
  with _ -> failwith ("Error loading " ^ f) in
  Printf.printf "Read %s with %d examples\n%!" f (num_processed training);
  training
