module type Monoid = sig
  type t
  val plus : t -> t -> t
  val zero : t
end

module IntMonoid = struct
  type t = int
  let plus = (+)
  let zero = 0
end

module IntPairMonoid = struct
  type t = int * int
  let plus (x1, y1) (x2, y2) = (x1 + x2, y1 + y2)
  let zero = (0, 0)
end
