(* File: match.mli *)
(* Author: Chad E Brown *)
(* Created: December 2010 *)

open Syntax

exception NotGround
exception PatternMatchFailed

type metatrm =
  | MGround of trm
  | MVar of metatrm option ref * metatrm list
  | MLam of stp * metatrm
  | MAp of metatrm * metatrm

val to_meta : trm -> metatrm

val meta_to_ground : (string,trm) Hashtbl.t -> metatrm -> trm

val metatermNotFreeIn : metatrm -> int -> bool
val metashift : metatrm -> int -> int -> metatrm
val metasubst : metatrm -> int -> metatrm -> metatrm
val metanorm : metatrm -> metatrm (** only does beta normalization [and dneg], no eta, no delta **)
val gen_mlam_body:stp -> metatrm -> metatrm

val meta_copy : metatrm -> (metatrm option ref * metatrm option ref) list -> metatrm

type ctx = stp list
type dpair = ctx * metatrm * trm * stp

val mem_eq : metatrm option ref -> metatrm option ref list -> bool
val pattern_match : dpair list -> dpair list
val update_strict : metatrm option ref list -> metatrm -> metatrm option ref list

val new_evar : int -> ctx -> stp -> (metatrm option ref * metatrm)
val copy_evar : int -> metatrm option ref -> metatrm option ref
val string_of_evar : metatrm option ref -> string
val metatrm_str : metatrm -> string

