(* File: satallaxtop.ml *)
(* Author: Chad E Brown *)
(* Created: September 2010/April 2011 [satallaxtop] *)
(* This is just a copy of satallax.ml without the part at the end that does the work. *)

open Flags
open Syntax
open State
open Search
open Proofterm

exception Timeout
exception InputHelpError of string
exception InputError of string
exception UnclassifiedError

let coqfile = ref "";; 

(*** Satallax 2.0 default schedule. 36 modes. 610s total (10m10s). ***)
let strategy_schedule = [
("mode14",27);
("mode111",24);
("mode14a",25);
("mode174",9);
("mode188",9);
("mode176",14);
("mode219",15);
("mode80",16);
("mode173",6);
("mode187",6);
("mode168",7);
("mode163",6);
("mode8a",9);
("mode19c",6);
("mode190",6);
("mode171",6);
("mode175",6);
("mode164",6);
("mode108",8);
("mode186",6);
("mode4a",6);
("mode104",6);
("mode179",6);
("mode218",7);
("mode128",6);
("mode103",6);
("mode185",6);
("mode41c",6);
("mode3a",6);
("mode189",6);
("mode86",36);
("mode92",40);
("mode177",39);
("mode165",97);
("mode94",60);
("mode191",60)
];;

let print_help () =
  (print_string "Usage: satallax [-[Vvp]] [-verbose <int>] [-P <PicoMus>] [-M <modedir>] [-m <modefile>] [-t <timeout in seconds>] <problemfile>";
   print_newline();
   print_string "-M <dir> : Set the directory in which the mode file is stored.";
   print_newline();
   print_string "       The default mode directory is the 'modes' subdirectory of the Satallax directory.";
   print_newline();
   print_string "-m : Mode";
   print_newline();
   print_string "-P <file> : PicoMus binary file";
   print_newline();
   print_string "-V : Print version number and quit";
   print_newline();
   print_string "-v : Verbose";
   print_newline();
   print_string "-verbose <int> : Verbosity of given level";
   print_newline();
   print_string "-c [<file>|-] : Create a Coq version of problem, with the proof term if -p is included and proof search succeeds";
   print_newline();
   print_string "-p : Print proof term";
   print_newline());;

(*** Load the mode (error if cannot find it) ***)
let comment_line_p l =
  if (String.length l = 0) then
    true
  else
    (l.[0] = ';');;

let rec read_mode_file mf =
  let l = input_line mf in
  if (comment_line_p l) then
    read_mode_file mf
  else
    read_mode_file_value mf l
and read_mode_file_value mf flagname =
  let l = input_line mf in
  if (comment_line_p l) then
    read_mode_file_value mf flagname
  else if (l = "true") then
    begin
      set_bool_flag flagname true;
      read_mode_file mf
    end
  else if (l = "false") then
    begin
      set_bool_flag flagname false;
      read_mode_file mf
    end
  else
    begin
      set_int_flag flagname (int_of_string l);
      read_mode_file mf
    end

let modedir = ref (Config.satallaxdir ^ "/modes")
  
let load_mode m =
  let modefile = (!modedir ^ "/" ^ m) in
  if (Sys.file_exists modefile) then
    begin
      init_flags();
      try
	read_mode_file (open_in modefile)
      with
      | End_of_file -> ()
    end
  else
    raise (InputError ("Could not find mode " ^ modefile));;

let read_thf_file (f:string) (include_fun : string -> unit) =
  let ch = Lexing.from_channel (open_in f) in
  let old_include_fun = !st_include_fun in
  st_include_fun := include_fun;
(***  List.iter Tptp_config.process_thf (Tptp_parser.tptp_file Tptp_lexer.token ch); ***)
  ignore (Tptp_parser.tptp_file Tptp_lexer.token ch);
  if (!verbosity > 4) then Printf.printf "Finished reading thf file %s\n" f;
  st_include_fun := old_include_fun

let rec find_read_thf_file_r odir dir f =
  let ff = (dir ^ "/" ^ f) in
  if (Sys.file_exists ff) then
    read_thf_file ff (find_read_thf_file odir)
  else if (String.length dir > 1) then
    find_read_thf_file_r odir (Filename.dirname dir) f
  else
    raise (FileNotFound f)
and find_read_thf_file dir f =
  let ff = (dir ^ "/" ^ f) in
  if (Sys.file_exists ff) then
    read_thf_file ff (find_read_thf_file dir)
  else
    begin
      try
	let tptpdir = Sys.getenv "TPTP" in
	let tff = (tptpdir ^ "/" ^ f) in
	if (Sys.file_exists tff) then
	  read_thf_file tff (find_read_thf_file dir)
	else
	  find_read_thf_file_r dir dir f
      with
      | Not_found -> find_read_thf_file_r dir dir f
    end

