open Syntax

type refutation =
	(* Conflict(m1,m2), where [m1] = [~m2] *)
   Conflict of trm * trm
	(* Fal(m), where [m]=False *)
 | Fal of trm
	(* NegRefl(m), where [m]=~(s=s) for some term s*)
 | NegRefl of trm
	(* Implication(h,m1,m2,R1,R2), where [h]=s->t, [~m1]=s, [m2]=t *)
 | Implication of trm * trm * trm * refutation * refutation  
 | Disjunction of trm * trm * trm * refutation * refutation
 | NegConjunction of trm * trm * trm * refutation * refutation  
 | NegImplication of trm * trm * trm * refutation
 | Conjunction of trm * trm * trm * refutation 
 | NegDisjunction of trm * trm * trm * refutation 
	(* All(h,s,R,a,n,t), where [h] = forall_a.p , s = [pt]  *)
 | All of trm * trm * refutation * stp * trm *trm
	(* NegAll(h,s,R,a,n,x), where [~h] = forall_a.p , s = [px] *)
 | NegAll of trm * trm * refutation * stp * trm * string
 | Exist of trm * trm * refutation * stp * trm * string
 | NegExist of trm * trm * refutation * stp * trm *trm
	(* Mating(h1,h2,m_1..m_n,r_1..r_n), where [m_i]= ~(s_i = t_i), [h1 or h2]= p s_1 .. s_n, [h2 or h1]= ~p t_1 .. t_n*)
 | Mating of trm * trm * trm list * refutation list
	(* Decomposition(h,m_1..m_n,r_1..r_n), where [m_i]= ~(s_i = t_i), [h]= ~(p s_1 .. s_n=p t_1 .. t_n) *)
 | Decomposition of trm * trm list * refutation list 
 | Confront of trm * trm * trm * trm * trm * trm * refutation * refutation 
	(* Transitivity( of equality*)
 | Trans of trm * trm * trm * refutation
	(* Propositional Extensionality*)
 | NegEqualProp of trm * trm * trm * refutation * refutation
	(* Propositional Equality*)
 | EqualProp of trm * trm * trm * refutation * refutation
 | NegAequivalenz of trm * trm * trm * refutation * refutation
 | Aequivalenz of trm * trm * trm * refutation * refutation
	(* Functional Extensionality*)
 | NegEqualFunc of trm * trm * refutation
	(* Functional Equality*)
 | EqualFunc of trm * trm * refutation
 | ChoiceR of trm * trm * trm * trm * refutation * refutation 
 | Cut of trm * refutation * refutation     
 | DoubleNegation of trm * trm * refutation  
 | Rewrite of trm * trm * trm * refutation  
	(* Unfold definition*)
 | Delta of trm * trm * string * refutation
	(* Not_Yet_Implemented: used for debugging to indicate an error or uncaught cases*)
 | NYI of trm * trm * refutation 
	(* Used to close Branches after a timeout occurs*)
 | Timeout 
