% Domain   : Syntactic
% Problem  : Binary choice on individuals 2
% English  : There is an Epsb such that epsa and Epsb work together to give an a and b such that R a b holds,
%            if such an a and b exist for a binary relation R on $i.
% Refs     : [Bac10] Backes (2010), Tableaux for Higher-Order Logic with
%            If-Then-Else, Description and Choice. (Master's Thesis)
%          : [Bro11] Brown (2011), Email to Geoff Sutcliffe
% Source   : Section 7.1 of [Bac10]
% Names    : CHOICE8 [Bro11]
% Status   : Theorem
% Comments : THF0 syntax
%          : A choice operator on i can be used to define a choice operator on i*i (Curried).
%            In this version, the first half of the solution is given.
%            Difficulty: Hard
thf(eps,type,(eps : (($i > $o) > $i))).
thf(choiceax,axiom,(! [P : ($i > $o)] : ((? [X : $i] : (P @ X)) => (P @ (eps @ P))))).
thf(epsa,type,(epsa : (($i > ($i > $o)) > $i))).
thf(epsad,definition,(epsa = (^ [R : ($i > ($i > $o))] : (eps @ (^ [X : $i] : (? [Y : $i] : ((R @ X) @ Y))))))).
thf(conj,conjecture,(? [Epsb : (($i > ($i > $o)) > $i)] : (! [R : ($i > ($i > $o))] : ((? [X : $i, Y : $i] : ((R @ X) @ Y)) => ((R @ (epsa @ R)) @ (Epsb @ R)))))).

