% Domain   : Set theory
% Problem  : If a set union is nonempty, then we can choose a nonempty set in the set.
% Refs     : [Bro11b] Brown (March 2011), Email to Geoff Sutcliffe
% Source   : [Bro11b]
% Names    : CHOICE34 [Bro11b]
% Status   : Theorem
% Comments : THF0 syntax
%          : Assume eps is a choice function on $i and epsio is a choice function on $i>$o.
%            If the union of a collection C of sets is nonempty, then
%            choosenonempty C := epsio (^ Y . C Y /\ Y (eps Y))
%            gives a nonempty set in C.
thf(eps,type,(eps : (($i > $o) > $i))).
thf(choiceax,axiom,(! [P : ($i > $o)] : ((? [X : $i] : (P @ X)) => (P @ (eps @ P))))).
thf(epsio,type,(epsio : ((($i > $o) > $o) > ($i > $o)))).
thf(choiceaxio,axiom,(! [P : (($i > $o) > $o)] : ((? [X : ($i > $o)] : (P @ X)) => (P @ (epsio @ P))))).
thf(setunion,type,(setunion : ((($i > $o) > $o) > ($i > $o)))).
thf(setuniond,definition,(setunion = (^ [C : (($i > $o) > $o)] : (^ [X : $i] : (? [Y : ($i > $o)] : ((C @ Y) & (Y @ X))))))).
thf(choosenonempty,type,(choosenonempty : ((($i > $o) > $o) > ($i > $o)))).
thf(choosenonemptyd,definition,(choosenonempty = (^ [C : (($i > $o) > $o)] : (epsio @ (^ [Y : ($i > $o)] : ((C @ Y) & (Y @ (eps @ Y)))))))).
thf(c,type,(c : (($i > $o) > $o))).
thf(a,type,(a : $i)).
thf(ca,axiom,((setunion @ c) @ a)).
thf(conj,conjecture,((c @ (choosenonempty @ c)) & (? [X : $i] : ((choosenonempty @ c) @ X)))).


