% Domain   : Puzzle
% Problem  : Choice on $o>$o applied to choice on $o is not negation (in THF)
% Refs     : [Bro11b] Brown (March 2011), Email to Geoff Sutcliffe
% Source   : [Bro11b]
% Names    : CHOICE31b [Bro11b]
% Status   : Theorem
% Comments : THF syntax
%          : Assume epso and epsoo are the @+ (THF syntax) choice operators on $o and $o>$o, respectively.
%          : epso can also be viewed as a predicate on $o>$o, so we can apply epsoo to epso.
%            The term (epsoo @ epso) is of type $o>$o.  This function is such that
%            if it is true for $false, then it is true for $true.
%            Proof Sketch: If the conjecture were not true, then (epsoo @ epso) would be the negation function.
%            However, negation is the only function $o>$o for which we are certain epso returns $false.
thf(epso,type,(epso : (($o > $o) > $o))).
thf(choiceaxo,definition,(epso = (^ [P : ($o > $o)] : (@+ [X : $o] : (P @ X))))).
thf(epsoo,type,(epsoo : ((($o > $o) > $o) > ($o > $o)))).
thf(choiceaxoo,definition,(epsoo = (^ [P : (($o > $o) > $o)] : (@+ [X : ($o > $o)] : (P @ X))))).
thf(c,conjecture,(((epsoo @ epso) @ $false) => ((epsoo @ epso) @ $true))).


