% Domain   : Syntactic
% Problem  : If-then-else on $i defined from choice on $i
% Refs     : [Bro11] Brown (2011), Email to Geoff Sutcliffe
% Source   : [Bro11]
% Names    : CHOICE27 [Bro11]
% Status   : Theorem
% Comments : THF0 syntax
%          : Two choice operators on $i are used to define two if-then-else operators at $i.
%            Check that the two if-then-else operators are the same.
thf(eps1,type,(eps1 : (($i > $o) > $i))).
thf(choiceax1,axiom,(! [P : ($i > $o)] : ((? [X : $i] : (P @ X)) => (P @ (eps1 @ P))))).
thf(if1,type,(if1 : ($o > ($i > ($i > $i))))).
thf(if1d,definition,(if1 = (^ [B : $o, X : $i, Y : $i] : (eps1 @ (^ [Z : $i] : ((B & (Z = X)) | ((~ (B)) & (Z = Y)))))))).
thf(eps2,type,(eps2 : (($i > $o) > $i))).
thf(choiceax2,axiom,(! [P : ($i > $o)] : ((? [X : $i] : (P @ X)) => (P @ (eps2 @ P))))).
thf(if2,type,(if2 : ($o > ($i > ($i > $i))))).
thf(if2d,definition,(if2 = (^ [B : $o, X : $i, Y : $i] : (eps2 @ (^ [Z : $i] : ((B & (Z = X)) | ((~ (B)) & (Z = Y)))))))).
thf(conj,conjecture,(if1 = if2)).

