% Domain   : Syntactic
% Problem  : Choice Complement
% English  : The choice operator applied to complements of predicates
%            chooses an element not in the predicate, if there is one.
% Refs     : [Bac10] Backes (2010), Tableaux for Higher-Order Logic with
%            If-Then-Else, Description and Choice. (Master's Thesis)
%          : [Bro11] Brown (2011), Email to Geoff Sutcliffe
% Source   : Section 6.5 of [Bac10]
% Names    : CHOICE24 [Bro11]
% Status   : Theorem
% Comments : THF0 syntax
thf(eps,type,(eps : (($i > $o) > $i))).
thf(choiceax,axiom,(! [P : ($i > $o)] : ((? [X : $i] : (P @ X)) => (P @ (eps @ P))))).
thf(epscomp,type,(epscomp : (($i > $o) > $i))).
thf(epscompd,definition,(epscomp = (^ [P : ($i > $o)] : (eps @ (^ [X : $i] : (~ (P @ X))))))).
thf(choicecomp,conjecture,(! [P : ($i > $o)] : ((? [X : $i] : (~ (P @ X))) => (~ (P @ (epscomp @ P)))))).


