% Domain   : Syntactic
% Problem  : If-then-else on $i>$i defined from choice on $i>$i
% Refs     : [Bro11] Brown (2011), Email to Geoff Sutcliffe
% Source   : [Bro11]
% Names    : CHOICE16b [Bro11]
% Status   : Theorem
% Comments : THF0 syntax
%          : A choice operator on ($i>$i) is used to define an if-then-else operator at ($i>$i).
%            Check that it always returns the then-part or the else-part.
%            Difficulty: Moderate/Difficult
thf(epsii,type,(epsii : ((($i > $i) > $o) > ($i > $i)))).
thf(choiceaxii,axiom,(! [P : (($i > $i) > $o)] : ((? [X : ($i > $i)] : (P @ X)) => (P @ (epsii @ P))))).
thf(if,type,(if : ($o > (($i > $i) > (($i > $i) > ($i > $i)))))).
thf(ifd,definition,(if = (^ [B : $o, X : ($i > $i), Y : ($i > $i)] : (epsii @ (^ [Z : ($i > $i)] : ((B & (Z = X)) | ((~ (B)) & (Z = Y)))))))).
thf(conj,conjecture,(! [B : $o, X : ($i > $i), Y : ($i > $i)] : (((((if @ B) @ X) @ Y) = X) | ((((if @ B) @ X) @ Y) = Y)))).


