% Domain   : Syntactic
% Problem  : 3-ary choice on individuals
% English  : epsa, epsb and epsc work together to give an a, b and c such that R a b c holds,
%            if such an a, b and c exist for a 3-ary relation R on $i.
% Refs     : [Bro11] Brown (2011), Email to Geoff Sutcliffe
% Source   : [Bro11]
% Names    : CHOICE11 [Bro11]
% Status   : Theorem
% Comments : THF0 syntax
%          : A choice operator on i can be used to define a choice operator on i*i*i (Curried).
%            In this version, the solution is given and the goal is to check that it works.
%            Difficulty: Easy
thf(eps,type,(eps : (($i > $o) > $i))).
thf(choiceax,axiom,(! [P : ($i > $o)] : ((? [X : $i] : (P @ X)) => (P @ (eps @ P))))).
thf(epsa,type,(epsa : (($i > ($i > ($i > $o))) > $i))).
thf(epsad,definition,(epsa = (^ [R : ($i > ($i > ($i > $o)))] : (eps @ (^ [X : $i] : (? [Y : $i, Z : $i] : (((R @ X) @ Y) @ Z))))))).
thf(epsb,type,(epsb : (($i > ($i > ($i > $o))) > $i))).
thf(epsbd,definition,(epsb = (^ [R : ($i > ($i > ($i > $o)))] : (eps @ (^ [Y : $i] : (? [Z : $i] : (((R @ (epsa @ R)) @ Y) @ Z))))))).
thf(epsc,type,(epsc : (($i > ($i > ($i > $o))) > $i))).
thf(epscd,definition,(epsc = (^ [R : ($i > ($i > ($i > $o)))] : (eps @ (^ [Z : $i] : (((R @ (epsa @ R)) @ (epsb @ R)) @ Z)))))).
thf(conj,conjecture,(! [R : ($i > ($i > ($i > $o)))] : ((? [X : $i, Y : $i, Z : $i] : (((R @ X) @ Y) @ Z)) => (((R @ (epsa @ R)) @ (epsb @ R)) @ (epsc @ R))))).


