% Domain   : Syntactic
% Problem  : Skolem Property on individuals when a Choice Operator is given.
% English  : Let eps be a choice operator on $i.  For every total relation r on $i
%            there is a corresponding function from $i to $i.
% Refs     : [Bro11] Brown (2011), Email to Geoff Sutcliffe
% Source   : [Bro11]
% Names    : CHOICE1 [Bro11]
% Status   : Theorem
% Comments : THF0 syntax
thf(eps,type,(eps : (($i > $o) > $i))).
thf(choiceax,axiom,(! [P : ($i > $o)] : ((? [X : $i] : (P @ X)) => (P @ (eps @ P))))).
thf(r,type,(r : ($i > ($i > $o)))).
thf(rtotal,axiom,(! [X : $i] : (? [Y : $i] : ((r @ X) @ Y)))).
thf(skolem,conjecture,(? [F : ($i > $i)] : (! [X : $i] : ((r @ X) @ (F @ X))))).
