type token =
  | Unrecognized
  | LBrkt
  | RBrkt
  | LParen
  | RParen
  | Comma
  | Period
  | Colon
  | Ampersand
  | At
  | Vline
  | Star
  | Plus
  | Arrow
  | Tilde
  | Caret
  | Question
  | Exclamation
  | Equal
  | Nequal
  | Iff
  | Implies
  | If
  | Niff
  | Nor
  | Nand
  | Pi
  | Sigma
  | Fforall
  | Eexists
  | Assign
  | Longarrow
  | Thf
  | Fof
  | Cnf
  | Dollar_thf
  | Dollar_fof
  | Dollar_cnf
  | Dollar_fot
  | Choice
  | Include
  | Upper_word of (string)
  | Lower_word of (string)
  | Single_quoted of (string)
  | Dollar_word of (string)
  | Dollar_dollar_word of (string)
  | Distinct_object of (string)
  | Real of (string)
  | Unsigned_integer of (string)
  | Signed_integer of (string)
  | EOF

open Parsing;;
# 5 "src/parser/tptp_parser.mly"
open Lexing
open Formula

let print_error startpos endpos msg =
	if startpos.pos_lnum = endpos.pos_lnum then
		Printf.printf "line %d, characters %d-%d: %s\n"
		startpos.pos_lnum (startpos.pos_cnum - startpos.pos_bol)
		(endpos.pos_cnum - endpos.pos_bol)
		msg
	else
		Printf.printf "line %d, character %d - line %d, character %d: %s\n"
		startpos.pos_lnum (startpos.pos_cnum - startpos.pos_bol)
		endpos.pos_lnum (endpos.pos_cnum - endpos.pos_bol)
		msg

# 72 "src/parser/tptp_parser.ml"
let yytransl_const = [|
  257 (* Unrecognized *);
  258 (* LBrkt *);
  259 (* RBrkt *);
  260 (* LParen *);
  261 (* RParen *);
  262 (* Comma *);
  263 (* Period *);
  264 (* Colon *);
  265 (* Ampersand *);
  266 (* At *);
  267 (* Vline *);
  268 (* Star *);
  269 (* Plus *);
  270 (* Arrow *);
  271 (* Tilde *);
  272 (* Caret *);
  273 (* Question *);
  274 (* Exclamation *);
  275 (* Equal *);
  276 (* Nequal *);
  277 (* Iff *);
  278 (* Implies *);
  279 (* If *);
  280 (* Niff *);
  281 (* Nor *);
  282 (* Nand *);
  283 (* Pi *);
  284 (* Sigma *);
  285 (* Fforall *);
  286 (* Eexists *);
  287 (* Assign *);
  288 (* Longarrow *);
  289 (* Thf *);
  290 (* Fof *);
  291 (* Cnf *);
  292 (* Dollar_thf *);
  293 (* Dollar_fof *);
  294 (* Dollar_cnf *);
  295 (* Dollar_fot *);
  296 (* Choice *);
  297 (* Include *);
    0 (* EOF *);
    0|]

let yytransl_block = [|
  298 (* Upper_word *);
  299 (* Lower_word *);
  300 (* Single_quoted *);
  301 (* Dollar_word *);
  302 (* Dollar_dollar_word *);
  303 (* Distinct_object *);
  304 (* Real *);
  305 (* Unsigned_integer *);
  306 (* Signed_integer *);
    0|]

let yylhs = "\255\255\
\001\000\001\000\001\000\002\000\002\000\002\000\005\000\005\000\
\005\000\007\000\008\000\009\000\013\000\013\000\011\000\011\000\
\011\000\011\000\011\000\012\000\012\000\012\000\018\000\018\000\
\018\000\018\000\021\000\021\000\021\000\025\000\026\000\026\000\
\026\000\029\000\029\000\030\000\030\000\031\000\031\000\023\000\
\023\000\023\000\023\000\023\000\023\000\032\000\038\000\038\000\
\039\000\039\000\041\000\033\000\034\000\034\000\035\000\035\000\
\046\000\046\000\024\000\024\000\042\000\048\000\027\000\027\000\
\027\000\049\000\049\000\050\000\050\000\051\000\051\000\036\000\
\052\000\052\000\053\000\053\000\019\000\019\000\054\000\054\000\
\020\000\014\000\014\000\055\000\055\000\057\000\058\000\058\000\
\060\000\060\000\061\000\061\000\056\000\056\000\056\000\056\000\
\062\000\066\000\066\000\063\000\063\000\015\000\015\000\069\000\
\069\000\070\000\070\000\070\000\022\000\045\000\045\000\045\000\
\068\000\037\000\037\000\037\000\037\000\037\000\028\000\028\000\
\043\000\043\000\043\000\065\000\065\000\059\000\059\000\059\000\
\059\000\059\000\059\000\072\000\072\000\067\000\074\000\076\000\
\064\000\064\000\064\000\078\000\079\000\079\000\082\000\083\000\
\085\000\073\000\071\000\080\000\044\000\044\000\087\000\087\000\
\087\000\081\000\081\000\047\000\089\000\088\000\088\000\092\000\
\092\000\093\000\084\000\084\000\095\000\096\000\086\000\086\000\
\097\000\098\000\040\000\090\000\090\000\016\000\099\000\099\000\
\099\000\100\000\100\000\100\000\100\000\100\000\100\000\003\000\
\003\000\003\000\003\000\101\000\101\000\102\000\102\000\017\000\
\017\000\103\000\006\000\105\000\105\000\106\000\106\000\010\000\
\010\000\091\000\091\000\091\000\091\000\091\000\091\000\075\000\
\075\000\075\000\075\000\075\000\077\000\094\000\094\000\094\000\
\104\000\004\000\000\000\000\000\000\000"

let yylen = "\002\000\
\001\000\002\000\001\000\001\000\001\000\001\000\001\000\001\000\
\001\000\010\000\010\000\010\000\003\000\001\000\001\000\001\000\
\001\000\001\000\001\000\001\000\001\000\001\000\001\000\001\000\
\001\000\001\000\001\000\001\000\001\000\003\000\001\000\001\000\
\001\000\003\000\003\000\003\000\003\000\003\000\003\000\001\000\
\001\000\001\000\001\000\001\000\003\000\006\000\001\000\003\000\
\001\000\001\000\003\000\004\000\001\000\001\000\002\000\003\000\
\001\000\003\000\003\000\003\000\001\000\001\000\001\000\001\000\
\001\000\003\000\003\000\003\000\003\000\003\000\003\000\006\000\
\001\000\003\000\003\000\003\000\003\000\003\000\001\000\001\000\
\003\000\001\000\001\000\001\000\001\000\003\000\001\000\001\000\
\003\000\003\000\003\000\003\000\001\000\001\000\001\000\003\000\
\006\000\001\000\003\000\002\000\001\000\003\000\001\000\001\000\
\003\000\001\000\002\000\001\000\003\000\001\000\001\000\001\000\
\003\000\001\000\001\000\001\000\001\000\001\000\001\000\001\000\
\001\000\001\000\001\000\001\000\001\000\001\000\001\000\001\000\
\001\000\001\000\001\000\001\000\001\000\001\000\001\000\001\000\
\001\000\001\000\001\000\001\000\001\000\001\000\001\000\003\000\
\001\000\001\000\001\000\001\000\001\000\001\000\001\000\001\000\
\001\000\001\000\004\000\001\000\001\000\001\000\001\000\001\000\
\001\000\001\000\001\000\004\000\001\000\001\000\001\000\004\000\
\001\000\001\000\001\000\001\000\003\000\001\000\001\000\003\000\
\001\000\001\000\004\000\001\000\001\000\001\000\001\000\004\000\
\004\000\004\000\004\000\002\000\003\000\001\000\003\000\002\000\
\001\000\001\000\006\000\004\000\001\000\001\000\003\000\001\000\
\001\000\001\000\001\000\001\000\001\000\001\000\001\000\001\000\
\001\000\001\000\001\000\001\000\001\000\001\000\001\000\001\000\
\001\000\000\000\002\000\002\000\002\000"

let yydefred = "\000\000\
\000\000\000\000\000\000\000\000\006\000\000\000\000\000\000\000\
\000\000\000\000\001\000\003\000\004\000\005\000\007\000\008\000\
\009\000\220\000\000\000\000\000\000\000\000\000\221\000\000\000\
\000\000\000\000\000\000\002\000\000\000\000\000\000\000\000\000\
\204\000\205\000\206\000\207\000\202\000\203\000\201\000\000\000\
\200\000\000\000\000\000\217\000\000\000\000\000\000\000\133\000\
\132\000\134\000\115\000\124\000\125\000\146\000\126\000\127\000\
\128\000\129\000\130\000\131\000\117\000\118\000\122\000\123\000\
\000\000\209\000\210\000\211\000\212\000\116\000\171\000\208\000\
\213\000\161\000\214\000\216\000\215\000\000\000\020\000\021\000\
\022\000\023\000\024\000\000\000\000\000\027\000\028\000\029\000\
\110\000\000\000\000\000\000\000\040\000\041\000\042\000\000\000\
\044\000\000\000\150\000\000\000\053\000\054\000\000\000\000\000\
\063\000\000\000\000\000\000\000\120\000\114\000\121\000\111\000\
\119\000\166\000\170\000\151\000\162\000\153\000\149\000\152\000\
\000\000\157\000\158\000\159\000\160\000\163\000\000\000\167\000\
\000\000\000\000\000\000\000\000\154\000\082\000\000\000\084\000\
\085\000\000\000\000\000\093\000\094\000\095\000\000\000\000\000\
\101\000\137\000\138\000\139\000\000\000\141\000\142\000\000\000\
\000\000\000\000\000\000\000\000\106\000\108\000\000\000\104\000\
\000\000\000\000\000\000\000\000\000\000\197\000\000\000\055\000\
\000\000\000\000\043\000\000\000\000\000\000\000\000\000\184\000\
\000\000\000\000\000\000\000\000\147\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\185\000\000\000\145\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\100\000\000\000\000\000\107\000\186\000\000\000\
\187\000\016\000\017\000\018\000\019\000\015\000\000\000\000\000\
\000\000\000\000\000\000\026\000\000\000\000\000\056\000\045\000\
\078\000\000\000\000\000\000\000\050\000\000\000\000\000\061\000\
\059\000\036\000\038\000\034\000\030\000\109\000\035\000\037\000\
\039\000\081\000\000\000\000\000\000\000\060\000\062\000\068\000\
\070\000\000\000\067\000\069\000\071\000\077\000\000\000\000\000\
\000\000\000\000\096\000\113\000\144\000\091\000\089\000\086\000\
\090\000\092\000\000\000\000\000\102\000\105\000\000\000\000\000\
\000\000\000\000\000\000\195\000\058\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\052\000\000\000\155\000\164\000\
\168\000\000\000\000\000\000\000\000\000\000\000\000\000\196\000\
\076\000\075\000\051\000\000\000\074\000\000\000\048\000\173\000\
\099\000\000\000\000\000\014\000\000\000\000\000\000\000\199\000\
\072\000\046\000\097\000\000\000\183\000\182\000\000\000\180\000\
\000\000\181\000\174\000\000\000\177\000\000\000\000\000\000\000\
\188\000\000\000\000\000\000\000\193\000\013\000\000\000\000\000\
\010\000\011\000\012\000\000\000\189\000\194\000\192\000\000\000\
\176\000\191\000\179\000"

let yydgoto = "\004\000\
\010\000\011\000\070\001\060\001\013\000\014\000\015\000\016\000\
\017\000\026\001\223\000\078\000\061\001\131\000\156\000\071\001\
\086\001\240\000\080\000\081\000\082\000\083\000\084\000\228\000\
\086\000\087\000\088\000\089\000\090\000\091\000\092\000\093\000\
\094\000\095\000\171\000\097\000\098\000\251\000\235\000\099\000\
\237\000\241\000\100\000\101\000\102\000\172\000\133\000\104\000\
\105\000\106\000\107\000\238\000\239\000\108\000\134\000\135\000\
\136\000\137\000\109\000\138\000\139\000\140\000\141\000\142\000\
\110\000\020\001\111\000\145\000\159\000\160\000\183\000\112\000\
\113\000\000\000\114\000\000\000\115\000\146\000\147\000\148\000\
\116\000\150\000\151\000\117\000\204\000\118\000\119\000\120\000\
\121\000\008\001\122\000\123\000\124\000\125\000\126\000\127\000\
\128\000\129\000\082\001\076\001\077\001\083\001\095\001\045\000\
\167\000\027\001"

let yysindex = "\124\000\
\049\255\049\255\164\000\000\000\000\000\043\255\091\255\099\255\
\104\255\049\255\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\118\255\128\255\147\255\157\255\000\000\007\000\
\007\000\007\000\048\255\000\000\195\000\042\001\067\001\065\002\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\109\255\
\000\000\142\255\149\255\000\000\156\255\145\000\195\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\163\255\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\162\255\000\000\000\000\
\000\000\000\000\000\000\117\000\000\000\000\000\000\000\000\000\
\000\000\159\255\168\255\158\255\000\000\000\000\000\000\172\255\
\000\000\189\255\000\000\201\255\000\000\000\000\215\255\124\255\
\000\000\212\255\213\255\202\255\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\228\255\000\000\000\000\000\000\000\000\000\000\237\255\000\000\
\239\255\042\001\240\255\022\255\000\000\000\000\050\000\000\000\
\000\000\241\255\249\255\000\000\000\000\000\000\254\255\042\001\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\092\001\065\002\246\255\000\000\000\000\253\255\000\000\
\004\000\244\255\244\255\244\255\008\000\000\000\012\000\000\000\
\244\000\014\000\000\000\011\000\021\000\023\000\014\255\000\000\
\244\000\244\000\244\000\244\000\000\000\244\000\244\000\244\000\
\244\000\244\000\025\000\252\255\244\000\244\000\244\000\244\000\
\244\000\244\000\244\000\244\000\065\002\065\002\065\002\034\000\
\000\000\065\002\000\000\065\002\042\001\042\001\042\001\042\001\
\042\001\252\255\000\000\025\255\225\255\000\000\000\000\092\001\
\000\000\000\000\000\000\000\000\000\000\000\000\029\000\038\000\
\046\000\007\000\051\000\000\000\215\255\244\000\000\000\000\000\
\000\000\014\255\026\000\045\000\000\000\027\000\054\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\059\000\057\000\061\000\000\000\000\000\000\000\
\000\000\072\000\000\000\000\000\000\000\000\000\062\000\082\000\
\084\000\090\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\091\000\095\000\000\000\000\000\195\000\042\001\
\067\001\094\000\111\000\000\000\000\000\110\000\244\000\244\000\
\122\000\014\255\123\000\252\255\000\000\065\002\000\000\000\000\
\000\000\252\255\126\000\129\000\129\000\129\000\007\000\000\000\
\000\000\000\000\000\000\244\000\000\000\244\000\000\000\000\000\
\000\000\042\001\006\001\000\000\127\000\139\000\140\000\000\000\
\000\000\000\000\000\000\031\255\000\000\000\000\144\000\000\000\
\142\000\000\000\000\000\143\000\000\000\148\000\151\000\152\000\
\000\000\159\000\193\000\175\000\000\000\000\000\006\001\006\001\
\000\000\000\000\000\000\006\001\000\000\000\000\000\000\200\000\
\000\000\000\000\000\000"

let yyrindex = "\000\000\
\198\001\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\208\001\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\210\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\093\255\032\255\000\000\000\000\000\000\
\000\000\088\255\138\255\144\255\000\000\000\000\000\000\027\002\
\000\000\000\000\000\000\140\001\000\000\000\000\003\002\000\000\
\000\000\203\255\216\255\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\164\001\000\000\000\000\000\000\000\000\000\000\188\001\000\000\
\212\001\000\000\000\000\000\000\000\000\000\000\045\255\000\000\
\000\000\052\255\056\255\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\097\000\000\000\000\000\049\002\
\071\002\000\000\000\000\000\000\000\000\000\000\071\255\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\224\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\236\001\000\000\000\000\000\000\
\000\000\000\000\000\000\111\255\000\000\000\000\246\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\247\000\000\000\000\000\000\000\000\000\
\000\000\243\255\000\000\000\000\000\000\000\000\242\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\248\000\000\000\000\000\000\000\000\000\000\000\
\000\000\249\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\210\000\210\000\210\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\210\000\000\000\
\151\255\000\000\000\000\040\255\000\000\000\000\000\000\000\000\
\000\000\020\255\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000"

let yygindex = "\000\000\
\000\000\018\000\251\001\255\255\000\000\000\000\000\000\000\000\
\000\000\186\000\193\255\233\000\067\255\134\255\232\000\000\000\
\000\000\024\000\211\001\000\000\000\000\000\000\155\000\238\255\
\000\000\000\000\000\000\192\001\000\000\000\000\000\000\000\000\
\000\000\000\000\002\000\000\000\000\000\015\001\080\255\065\000\
\000\000\079\255\000\000\230\255\000\000\078\001\073\000\174\000\
\121\001\000\000\000\000\027\001\084\001\000\000\000\000\136\255\
\000\000\000\000\184\001\000\000\000\000\000\000\000\000\232\255\
\022\000\022\001\030\000\242\255\167\001\106\001\191\001\000\000\
\140\255\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\235\255\000\000\000\000\247\255\000\000\009\000\000\000\000\000\
\000\000\072\255\233\255\000\000\000\000\223\254\000\000\000\000\
\000\000\000\000\216\254\000\000\240\000\196\254\000\000\000\000\
\000\000\023\001"

let yytablesize = 883
let yytable = "\012\000\
\041\000\041\000\041\000\132\000\132\000\161\000\157\000\200\000\
\149\000\149\000\085\000\252\000\254\000\009\001\010\001\203\000\
\158\000\234\000\075\001\018\000\152\000\152\000\190\000\211\000\
\190\000\074\001\096\001\028\000\085\000\021\001\096\000\098\001\
\068\001\081\001\074\001\216\000\026\000\026\000\153\000\153\000\
\054\000\181\000\175\000\166\000\175\000\175\000\024\000\097\001\
\005\000\083\000\083\000\143\000\079\000\074\001\074\001\071\000\
\087\000\087\000\074\001\144\000\088\000\088\000\080\000\033\000\
\034\000\035\000\019\000\020\000\021\000\022\000\173\000\036\000\
\071\000\037\000\038\000\103\000\103\000\069\001\075\000\076\000\
\077\000\006\000\007\000\008\000\014\001\015\001\016\001\017\001\
\018\001\009\000\031\000\044\000\031\000\031\000\025\000\025\000\
\203\000\025\000\025\000\224\000\225\000\103\000\026\000\132\000\
\062\000\062\000\062\000\027\000\149\000\056\001\051\001\062\001\
\063\001\049\000\162\000\252\000\049\000\132\000\031\000\103\000\
\152\000\029\000\149\000\025\000\001\000\002\000\003\000\132\000\
\213\000\157\000\214\000\030\000\149\000\149\000\152\000\191\000\
\192\000\193\000\153\000\158\000\032\000\049\000\032\000\032\000\
\152\000\152\000\033\000\163\000\033\000\033\000\031\000\143\000\
\153\000\178\000\164\000\178\000\178\000\045\001\178\000\144\000\
\032\000\165\000\153\000\153\000\175\000\143\000\176\000\186\000\
\032\000\184\000\007\001\007\001\007\001\144\000\033\000\012\001\
\185\000\013\001\132\000\132\000\132\000\132\000\132\000\149\000\
\149\000\149\000\149\000\149\000\250\000\132\000\188\000\157\000\
\173\000\067\001\149\000\152\000\152\000\152\000\152\000\152\000\
\170\000\158\000\041\000\187\000\189\000\064\000\152\000\064\000\
\064\000\040\000\042\000\043\000\253\000\153\000\153\000\153\000\
\153\000\153\000\065\000\006\001\065\000\065\000\190\000\194\000\
\153\000\195\000\143\000\143\000\143\000\143\000\143\000\197\000\
\196\000\064\000\144\000\144\000\144\000\144\000\144\000\236\000\
\198\000\229\000\199\000\054\000\201\000\066\000\065\000\066\000\
\066\000\229\000\215\000\208\000\236\000\132\000\132\000\210\000\
\157\000\209\000\149\000\149\000\085\000\229\000\229\000\216\000\
\217\000\226\000\158\000\007\001\229\000\231\000\152\000\152\000\
\227\000\066\000\019\001\230\000\218\000\219\000\220\000\041\000\
\096\000\232\000\046\000\233\000\221\000\033\001\222\000\132\000\
\153\000\153\000\023\001\073\001\149\000\071\000\011\001\033\000\
\034\000\035\000\236\000\024\001\073\001\143\000\079\000\036\000\
\152\000\037\000\038\000\025\001\032\001\144\000\050\001\039\000\
\031\001\028\001\205\000\034\001\206\000\035\001\036\001\073\001\
\073\001\037\001\153\000\038\001\073\001\085\001\055\000\056\000\
\057\000\058\000\059\000\060\000\242\000\243\000\244\000\143\000\
\245\000\246\000\247\000\248\000\249\000\193\000\039\001\144\000\
\040\001\255\000\255\000\255\000\255\000\255\000\041\001\103\000\
\042\001\043\001\236\000\047\001\236\000\140\000\140\000\229\000\
\229\000\140\000\019\001\140\000\000\001\001\001\002\001\004\001\
\005\001\048\001\049\001\151\000\151\000\140\000\140\000\140\000\
\140\000\140\000\140\000\072\001\177\000\178\000\179\000\180\000\
\170\000\052\001\054\001\078\001\072\001\058\001\059\001\054\000\
\181\000\055\000\056\000\057\000\058\000\059\000\060\000\079\001\
\080\001\087\001\046\000\168\000\169\000\084\001\088\001\072\001\
\072\001\048\000\089\001\049\000\072\001\090\001\091\001\050\000\
\051\000\052\000\053\000\054\000\092\001\055\000\056\000\057\000\
\058\000\059\000\060\000\061\000\062\000\063\000\064\000\065\000\
\068\001\033\000\034\000\035\000\066\000\067\000\068\000\069\000\
\070\000\036\000\071\000\037\000\038\000\072\000\073\000\074\000\
\075\000\076\000\077\000\093\001\046\000\218\000\047\000\019\000\
\020\000\021\000\022\000\048\000\099\001\049\000\065\001\219\000\
\066\001\050\000\051\000\052\000\053\000\054\000\218\000\055\000\
\056\000\057\000\058\000\059\000\060\000\061\000\062\000\063\000\
\064\000\065\000\057\000\033\000\034\000\035\000\066\000\067\000\
\068\000\069\000\070\000\036\000\071\000\037\000\038\000\072\000\
\073\000\074\000\075\000\076\000\077\000\046\000\172\000\169\000\
\073\000\047\000\098\000\198\000\048\000\023\000\049\000\044\001\
\046\001\174\000\050\000\051\000\052\000\053\000\054\000\068\001\
\055\000\056\000\057\000\058\000\059\000\060\000\061\000\062\000\
\063\000\064\000\065\000\182\000\033\000\034\000\035\000\066\000\
\067\000\068\000\069\000\070\000\036\000\071\000\037\000\038\000\
\072\000\073\000\074\000\075\000\076\000\077\000\033\000\034\000\
\035\000\019\000\020\000\021\000\022\000\130\000\036\000\071\000\
\037\000\038\000\055\001\029\001\069\001\075\000\076\000\077\000\
\050\000\003\001\052\000\053\000\053\001\030\001\207\000\057\001\
\212\000\022\001\202\000\094\001\000\000\064\001\154\000\000\000\
\000\000\000\000\033\000\034\000\035\000\066\000\067\000\068\000\
\069\000\155\000\036\000\071\000\037\000\038\000\072\000\073\000\
\074\000\075\000\076\000\077\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\033\000\034\000\035\000\066\000\067\000\
\068\000\069\000\155\000\036\000\071\000\037\000\038\000\072\000\
\073\000\074\000\075\000\076\000\077\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\033\000\034\000\035\000\066\000\
\067\000\068\000\069\000\000\000\036\000\071\000\037\000\038\000\
\072\000\073\000\074\000\075\000\076\000\077\000\112\000\000\000\
\112\000\112\000\000\000\112\000\112\000\112\000\112\000\112\000\
\112\000\112\000\000\000\000\000\000\000\000\000\112\000\112\000\
\112\000\112\000\112\000\112\000\112\000\112\000\156\000\000\000\
\156\000\156\000\112\000\156\000\156\000\156\000\156\000\156\000\
\156\000\156\000\000\000\000\000\000\000\000\000\156\000\156\000\
\156\000\156\000\156\000\156\000\156\000\156\000\165\000\000\000\
\165\000\165\000\156\000\165\000\165\000\165\000\165\000\165\000\
\165\000\165\000\000\000\000\000\000\000\000\000\165\000\165\000\
\165\000\165\000\165\000\165\000\165\000\165\000\169\000\000\000\
\169\000\169\000\165\000\169\000\169\000\169\000\169\000\169\000\
\169\000\169\000\000\000\000\000\000\000\000\000\169\000\169\000\
\169\000\169\000\169\000\169\000\169\000\169\000\154\000\000\000\
\154\000\154\000\169\000\000\000\154\000\154\000\154\000\154\000\
\154\000\154\000\000\000\000\000\000\000\000\000\154\000\154\000\
\154\000\154\000\154\000\154\000\154\000\154\000\000\000\154\000\
\154\000\000\000\154\000\154\000\154\000\154\000\154\000\154\000\
\154\000\000\000\000\000\000\000\000\000\154\000\154\000\154\000\
\154\000\154\000\154\000\154\000\154\000\000\000\000\000\043\000\
\043\000\079\000\043\000\043\000\043\000\043\000\043\000\043\000\
\043\000\000\000\000\000\000\000\000\000\043\000\043\000\043\000\
\043\000\043\000\043\000\043\000\043\000\143\000\143\000\000\000\
\000\000\143\000\000\000\143\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\162\000\162\000\143\000\143\000\143\000\
\143\000\143\000\143\000\148\000\148\000\000\000\000\000\148\000\
\000\000\148\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\153\000\153\000\148\000\148\000\148\000\148\000\148\000\
\148\000\033\000\034\000\035\000\066\000\067\000\068\000\069\000\
\000\000\036\000\071\000\037\000\038\000\072\000\073\000\074\000\
\075\000\076\000\077\000"

let yycheck = "\001\000\
\024\000\025\000\026\000\030\000\031\000\032\000\031\000\130\000\
\030\000\031\000\029\000\188\000\190\000\198\000\199\000\132\000\
\031\000\004\001\059\001\002\000\030\000\031\000\003\001\144\000\
\005\001\059\001\087\001\010\000\047\000\005\001\029\000\092\001\
\002\001\003\001\068\001\011\001\005\001\006\001\030\000\031\000\
\019\001\020\001\003\001\045\000\005\001\006\001\004\001\088\001\
\000\001\005\001\006\001\030\000\029\000\087\001\088\001\042\001\
\005\001\006\001\092\001\030\000\005\001\006\001\031\001\033\001\
\034\001\035\001\036\001\037\001\038\001\039\001\047\000\041\001\
\042\001\043\001\044\001\005\001\006\001\047\001\048\001\049\001\
\050\001\033\001\034\001\035\001\205\000\206\000\207\000\208\000\
\209\000\041\001\003\001\044\001\005\001\006\001\004\001\003\001\
\213\000\005\001\006\001\163\000\164\000\029\000\004\001\130\000\
\012\001\013\001\014\001\004\001\130\000\038\001\032\001\045\001\
\046\001\003\001\006\001\036\001\006\001\144\000\031\001\047\000\
\130\000\004\001\144\000\031\001\001\000\002\000\003\000\154\000\
\155\000\154\000\155\000\004\001\154\000\155\000\144\000\012\001\
\013\001\014\001\130\000\154\000\003\001\031\001\005\001\006\001\
\154\000\155\000\003\001\006\001\005\001\006\001\004\001\130\000\
\144\000\003\001\006\001\005\001\006\001\024\001\008\001\130\000\
\004\001\006\001\154\000\155\000\002\001\144\000\005\001\010\001\
\031\001\011\001\197\000\198\000\199\000\144\000\031\001\202\000\
\009\001\204\000\205\000\206\000\207\000\208\000\209\000\205\000\
\206\000\207\000\208\000\209\000\187\000\216\000\002\001\216\000\
\169\000\058\001\216\000\205\000\206\000\207\000\208\000\209\000\
\046\000\216\000\226\000\032\001\004\001\003\001\216\000\005\001\
\006\001\024\000\025\000\026\000\189\000\205\000\206\000\207\000\
\208\000\209\000\003\001\196\000\005\001\006\001\008\001\012\001\
\216\000\013\001\205\000\206\000\207\000\208\000\209\000\004\001\
\031\001\031\001\205\000\206\000\207\000\208\000\209\000\175\000\
\004\001\169\000\004\001\019\001\005\001\003\001\031\001\005\001\
\006\001\177\000\005\001\011\001\188\000\024\001\025\001\002\001\
\025\001\009\001\024\001\025\001\023\001\189\000\190\000\011\001\
\005\001\002\001\025\001\038\001\196\000\003\001\024\001\025\001\
\005\001\031\001\210\000\006\001\033\001\034\001\035\001\047\001\
\023\001\005\001\002\001\005\001\041\001\003\001\043\001\058\001\
\024\001\025\001\006\001\059\001\058\001\042\001\005\001\033\001\
\034\001\035\001\234\000\006\001\068\001\024\001\023\001\041\001\
\058\001\043\001\044\001\006\001\008\001\024\001\031\001\049\001\
\031\001\007\001\009\001\006\001\011\001\003\001\006\001\087\001\
\088\001\005\001\058\001\006\001\092\001\071\001\021\001\022\001\
\023\001\024\001\025\001\026\001\178\000\179\000\180\000\058\001\
\182\000\183\000\184\000\185\000\186\000\014\001\005\001\058\001\
\005\001\191\000\192\000\193\000\194\000\195\000\005\001\023\001\
\006\001\003\001\034\001\006\001\036\001\005\001\006\001\031\001\
\032\001\009\001\042\001\011\001\191\000\192\000\193\000\194\000\
\195\000\003\001\005\001\019\001\020\001\021\001\022\001\023\001\
\024\001\025\001\026\001\059\001\008\001\009\001\010\001\011\001\
\230\000\008\001\008\001\005\001\068\001\008\001\006\001\019\001\
\020\001\021\001\022\001\023\001\024\001\025\001\026\001\005\001\
\005\001\004\001\002\001\003\001\004\001\006\001\008\001\087\001\
\088\001\009\001\007\001\011\001\092\001\007\001\007\001\015\001\
\016\001\017\001\018\001\019\001\006\001\021\001\022\001\023\001\
\024\001\025\001\026\001\027\001\028\001\029\001\030\001\031\001\
\002\001\033\001\034\001\035\001\036\001\037\001\038\001\039\001\
\040\001\041\001\042\001\043\001\044\001\045\001\046\001\047\001\
\048\001\049\001\050\001\003\001\002\001\000\000\004\001\036\001\
\037\001\038\001\039\001\009\001\005\001\011\001\052\001\000\000\
\054\001\015\001\016\001\017\001\018\001\019\001\005\001\021\001\
\022\001\023\001\024\001\025\001\026\001\027\001\028\001\029\001\
\030\001\031\001\003\001\033\001\034\001\035\001\036\001\037\001\
\038\001\039\001\040\001\041\001\042\001\043\001\044\001\045\001\
\046\001\047\001\048\001\049\001\050\001\002\001\005\001\004\001\
\003\001\003\001\003\001\003\001\009\001\003\000\011\001\023\001\
\025\001\047\000\015\001\016\001\017\001\018\001\019\001\002\001\
\021\001\022\001\023\001\024\001\025\001\026\001\027\001\028\001\
\029\001\030\001\031\001\084\000\033\001\034\001\035\001\036\001\
\037\001\038\001\039\001\040\001\041\001\042\001\043\001\044\001\
\045\001\046\001\047\001\048\001\049\001\050\001\033\001\034\001\
\035\001\036\001\037\001\038\001\039\001\004\001\041\001\042\001\
\043\001\044\001\036\001\230\000\047\001\048\001\049\001\050\001\
\015\001\193\000\017\001\018\001\034\001\234\000\135\000\042\001\
\154\000\216\000\132\000\084\001\255\255\047\001\004\001\255\255\
\255\255\255\255\033\001\034\001\035\001\036\001\037\001\038\001\
\039\001\015\001\041\001\042\001\043\001\044\001\045\001\046\001\
\047\001\048\001\049\001\050\001\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\033\001\034\001\035\001\036\001\037\001\
\038\001\039\001\015\001\041\001\042\001\043\001\044\001\045\001\
\046\001\047\001\048\001\049\001\050\001\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\033\001\034\001\035\001\036\001\
\037\001\038\001\039\001\255\255\041\001\042\001\043\001\044\001\
\045\001\046\001\047\001\048\001\049\001\050\001\003\001\255\255\
\005\001\006\001\255\255\008\001\009\001\010\001\011\001\012\001\
\013\001\014\001\255\255\255\255\255\255\255\255\019\001\020\001\
\021\001\022\001\023\001\024\001\025\001\026\001\003\001\255\255\
\005\001\006\001\031\001\008\001\009\001\010\001\011\001\012\001\
\013\001\014\001\255\255\255\255\255\255\255\255\019\001\020\001\
\021\001\022\001\023\001\024\001\025\001\026\001\003\001\255\255\
\005\001\006\001\031\001\008\001\009\001\010\001\011\001\012\001\
\013\001\014\001\255\255\255\255\255\255\255\255\019\001\020\001\
\021\001\022\001\023\001\024\001\025\001\026\001\003\001\255\255\
\005\001\006\001\031\001\008\001\009\001\010\001\011\001\012\001\
\013\001\014\001\255\255\255\255\255\255\255\255\019\001\020\001\
\021\001\022\001\023\001\024\001\025\001\026\001\003\001\255\255\
\005\001\006\001\031\001\255\255\009\001\010\001\011\001\012\001\
\013\001\014\001\255\255\255\255\255\255\255\255\019\001\020\001\
\021\001\022\001\023\001\024\001\025\001\026\001\255\255\005\001\
\006\001\255\255\031\001\009\001\010\001\011\001\012\001\013\001\
\014\001\255\255\255\255\255\255\255\255\019\001\020\001\021\001\
\022\001\023\001\024\001\025\001\026\001\255\255\255\255\005\001\
\006\001\031\001\008\001\009\001\010\001\011\001\012\001\013\001\
\014\001\255\255\255\255\255\255\255\255\019\001\020\001\021\001\
\022\001\023\001\024\001\025\001\026\001\005\001\006\001\255\255\
\255\255\009\001\255\255\011\001\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\019\001\020\001\021\001\022\001\023\001\
\024\001\025\001\026\001\005\001\006\001\255\255\255\255\009\001\
\255\255\011\001\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\019\001\020\001\021\001\022\001\023\001\024\001\025\001\
\026\001\033\001\034\001\035\001\036\001\037\001\038\001\039\001\
\255\255\041\001\042\001\043\001\044\001\045\001\046\001\047\001\
\048\001\049\001\050\001"

let yynames_const = "\
  Unrecognized\000\
  LBrkt\000\
  RBrkt\000\
  LParen\000\
  RParen\000\
  Comma\000\
  Period\000\
  Colon\000\
  Ampersand\000\
  At\000\
  Vline\000\
  Star\000\
  Plus\000\
  Arrow\000\
  Tilde\000\
  Caret\000\
  Question\000\
  Exclamation\000\
  Equal\000\
  Nequal\000\
  Iff\000\
  Implies\000\
  If\000\
  Niff\000\
  Nor\000\
  Nand\000\
  Pi\000\
  Sigma\000\
  Fforall\000\
  Eexists\000\
  Assign\000\
  Longarrow\000\
  Thf\000\
  Fof\000\
  Cnf\000\
  Dollar_thf\000\
  Dollar_fof\000\
  Dollar_cnf\000\
  Dollar_fot\000\
  Choice\000\
  Include\000\
  EOF\000\
  "

let yynames_block = "\
  Upper_word\000\
  Lower_word\000\
  Single_quoted\000\
  Dollar_word\000\
  Dollar_dollar_word\000\
  Distinct_object\000\
  Real\000\
  Unsigned_integer\000\
  Signed_integer\000\
  "

let yyact = [|
  (fun _ -> failwith "parser")
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Formula.formula) in
    Obj.repr(
# 100 "src/parser/tptp_parser.mly"
               ( (!Tptp_config.accumulator2) _1 [] )
# 654 "src/parser/tptp_parser.ml"
               : Formula.formula list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : Formula.formula list) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : Formula.formula) in
    Obj.repr(
# 101 "src/parser/tptp_parser.mly"
                         ( (!Tptp_config.accumulator2) _2 _1 )
# 662 "src/parser/tptp_parser.ml"
               : Formula.formula list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'null) in
    Obj.repr(
# 102 "src/parser/tptp_parser.mly"
         ( [] )
# 669 "src/parser/tptp_parser.ml"
               : Formula.formula list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'annotated_formula) in
    Obj.repr(
# 105 "src/parser/tptp_parser.mly"
                      (_1)
# 676 "src/parser/tptp_parser.ml"
               : Formula.formula))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'file_include) in
    Obj.repr(
# 106 "src/parser/tptp_parser.mly"
                 (_1)
# 683 "src/parser/tptp_parser.ml"
               : Formula.formula))
; (fun __caml_parser_env ->
    Obj.repr(
# 107 "src/parser/tptp_parser.mly"
          ( let startpos = Parsing.rhs_start_pos 1 in
	    let endpos = Parsing.rhs_end_pos 1 in
            print_error startpos endpos "syntax error";
            failwith "Syntax Error")
# 692 "src/parser/tptp_parser.ml"
               : Formula.formula))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'thf_annotated) in
    Obj.repr(
# 114 "src/parser/tptp_parser.mly"
                  (_1)
# 699 "src/parser/tptp_parser.ml"
               : 'annotated_formula))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'fof_annotated) in
    Obj.repr(
# 115 "src/parser/tptp_parser.mly"
                  (_1)
# 706 "src/parser/tptp_parser.ml"
               : 'annotated_formula))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'cnf_annotated) in
    Obj.repr(
# 116 "src/parser/tptp_parser.mly"
                  (_1)
# 713 "src/parser/tptp_parser.ml"
               : 'annotated_formula))
; (fun __caml_parser_env ->
    let _3 = (Parsing.peek_val __caml_parser_env 7 : 'name) in
    let _5 = (Parsing.peek_val __caml_parser_env 5 : 'formula_role) in
    let _7 = (Parsing.peek_val __caml_parser_env 3 : 'thf_formula) in
    let _8 = (Parsing.peek_val __caml_parser_env 2 : 'annotations) in
    Obj.repr(
# 120 "src/parser/tptp_parser.mly"
    (Appl (Symbol "$$thf",[_3;_5;_7;_8]))
# 723 "src/parser/tptp_parser.ml"
               : 'thf_annotated))
; (fun __caml_parser_env ->
    let _3 = (Parsing.peek_val __caml_parser_env 7 : 'name) in
    let _5 = (Parsing.peek_val __caml_parser_env 5 : 'formula_role) in
    let _7 = (Parsing.peek_val __caml_parser_env 3 : 'fof_formula) in
    let _8 = (Parsing.peek_val __caml_parser_env 2 : 'annotations) in
    Obj.repr(
# 124 "src/parser/tptp_parser.mly"
    (Appl (Symbol "$$fof",[_3;_5;_7;_8]))
# 733 "src/parser/tptp_parser.ml"
               : 'fof_annotated))
; (fun __caml_parser_env ->
    let _3 = (Parsing.peek_val __caml_parser_env 7 : 'name) in
    let _5 = (Parsing.peek_val __caml_parser_env 5 : 'formula_role) in
    let _7 = (Parsing.peek_val __caml_parser_env 3 : 'cnf_formula) in
    let _8 = (Parsing.peek_val __caml_parser_env 2 : 'annotations) in
    Obj.repr(
# 128 "src/parser/tptp_parser.mly"
    (Appl (Symbol "$$cnf", [_3;_5;_7;_8]))
# 743 "src/parser/tptp_parser.ml"
               : 'cnf_annotated))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 1 : 'source) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'optional_info) in
    Obj.repr(
# 131 "src/parser/tptp_parser.mly"
                               (Appl (Symbol "$$annotations", [_2;_3]))
# 751 "src/parser/tptp_parser.ml"
               : 'annotations))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'null) in
    Obj.repr(
# 132 "src/parser/tptp_parser.mly"
         (_1)
# 758 "src/parser/tptp_parser.ml"
               : 'annotations))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : string) in
    Obj.repr(
# 135 "src/parser/tptp_parser.mly"
               ( Symbol _1 )
# 765 "src/parser/tptp_parser.ml"
               : 'formula_role))
; (fun __caml_parser_env ->
    Obj.repr(
# 136 "src/parser/tptp_parser.mly"
        ( Symbol "thf" )
# 771 "src/parser/tptp_parser.ml"
               : 'formula_role))
; (fun __caml_parser_env ->
    Obj.repr(
# 137 "src/parser/tptp_parser.mly"
        ( Symbol "fof" )
# 777 "src/parser/tptp_parser.ml"
               : 'formula_role))
; (fun __caml_parser_env ->
    Obj.repr(
# 138 "src/parser/tptp_parser.mly"
        ( Symbol "cnf" )
# 783 "src/parser/tptp_parser.ml"
               : 'formula_role))
; (fun __caml_parser_env ->
    Obj.repr(
# 139 "src/parser/tptp_parser.mly"
            ( Symbol "include" )
# 789 "src/parser/tptp_parser.ml"
               : 'formula_role))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'thf_logic_formula) in
    Obj.repr(
# 144 "src/parser/tptp_parser.mly"
                      ( _1 )
# 796 "src/parser/tptp_parser.ml"
               : 'thf_formula))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'thf_definition) in
    Obj.repr(
# 145 "src/parser/tptp_parser.mly"
                   ( _1 )
# 803 "src/parser/tptp_parser.ml"
               : 'thf_formula))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'thf_sequent) in
    Obj.repr(
# 146 "src/parser/tptp_parser.mly"
                ( _1 )
# 810 "src/parser/tptp_parser.ml"
               : 'thf_formula))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'thf_binary_formula) in
    Obj.repr(
# 150 "src/parser/tptp_parser.mly"
                       ( _1 )
# 817 "src/parser/tptp_parser.ml"
               : 'thf_logic_formula))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'thf_infix_unary) in
    Obj.repr(
# 151 "src/parser/tptp_parser.mly"
                    ( _1 )
# 824 "src/parser/tptp_parser.ml"
               : 'thf_logic_formula))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'thf_unitary_formula) in
    Obj.repr(
# 152 "src/parser/tptp_parser.mly"
                        ( _1 )
# 831 "src/parser/tptp_parser.ml"
               : 'thf_logic_formula))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'thf_type_formula) in
    Obj.repr(
# 153 "src/parser/tptp_parser.mly"
                     ( _1 )
# 838 "src/parser/tptp_parser.ml"
               : 'thf_logic_formula))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'thf_binary_pair) in
    Obj.repr(
# 156 "src/parser/tptp_parser.mly"
                    ( _1 )
# 845 "src/parser/tptp_parser.ml"
               : 'thf_binary_formula))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'thf_binary_tuple) in
    Obj.repr(
# 157 "src/parser/tptp_parser.mly"
                     ( _1 )
# 852 "src/parser/tptp_parser.ml"
               : 'thf_binary_formula))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'thf_binary_type) in
    Obj.repr(
# 158 "src/parser/tptp_parser.mly"
                    ( _1 )
# 859 "src/parser/tptp_parser.ml"
               : 'thf_binary_formula))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'thf_unitary_formula) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : 'thf_pair_connective) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'thf_unitary_formula) in
    Obj.repr(
# 162 "src/parser/tptp_parser.mly"
    (Appl (_2,[_1;_3]))
# 868 "src/parser/tptp_parser.ml"
               : 'thf_binary_pair))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'thf_or_formula) in
    Obj.repr(
# 165 "src/parser/tptp_parser.mly"
                   ( Appl (Symbol "|", _1) )
# 875 "src/parser/tptp_parser.ml"
               : 'thf_binary_tuple))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'thf_and_formula) in
    Obj.repr(
# 166 "src/parser/tptp_parser.mly"
                    ( Appl (Symbol "&", _1) )
# 882 "src/parser/tptp_parser.ml"
               : 'thf_binary_tuple))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'thf_apply_formula) in
    Obj.repr(
# 167 "src/parser/tptp_parser.mly"
                      ( Appl (Symbol "@", _1) )
# 889 "src/parser/tptp_parser.ml"
               : 'thf_binary_tuple))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'thf_unitary_formula) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'thf_unitary_formula) in
    Obj.repr(
# 170 "src/parser/tptp_parser.mly"
                                                  ([_1;_3])
# 897 "src/parser/tptp_parser.ml"
               : 'thf_or_formula))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'thf_or_formula) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'thf_unitary_formula) in
    Obj.repr(
# 171 "src/parser/tptp_parser.mly"
                                             (List.append _1 [_3])
# 905 "src/parser/tptp_parser.ml"
               : 'thf_or_formula))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'thf_unitary_formula) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'thf_unitary_formula) in
    Obj.repr(
# 174 "src/parser/tptp_parser.mly"
                                                      ([_1;_3])
# 913 "src/parser/tptp_parser.ml"
               : 'thf_and_formula))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'thf_and_formula) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'thf_unitary_formula) in
    Obj.repr(
# 175 "src/parser/tptp_parser.mly"
                                                  (List.append _1 [_3])
# 921 "src/parser/tptp_parser.ml"
               : 'thf_and_formula))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'thf_unitary_formula) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'thf_unitary_formula) in
    Obj.repr(
# 178 "src/parser/tptp_parser.mly"
                                               ([_1;_3])
# 929 "src/parser/tptp_parser.ml"
               : 'thf_apply_formula))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'thf_apply_formula) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'thf_unitary_formula) in
    Obj.repr(
# 179 "src/parser/tptp_parser.mly"
                                             (List.append _1 [_3])
# 937 "src/parser/tptp_parser.ml"
               : 'thf_apply_formula))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'thf_quantified_formula) in
    Obj.repr(
# 182 "src/parser/tptp_parser.mly"
                           ( _1 )
# 944 "src/parser/tptp_parser.ml"
               : 'thf_unitary_formula))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'thf_unary_formula) in
    Obj.repr(
# 183 "src/parser/tptp_parser.mly"
                      ( _1 )
# 951 "src/parser/tptp_parser.ml"
               : 'thf_unitary_formula))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'thf_atom) in
    Obj.repr(
# 184 "src/parser/tptp_parser.mly"
             ( _1 )
# 958 "src/parser/tptp_parser.ml"
               : 'thf_unitary_formula))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'thf_tuple) in
    Obj.repr(
# 185 "src/parser/tptp_parser.mly"
              ( _1 )
# 965 "src/parser/tptp_parser.ml"
               : 'thf_unitary_formula))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'thf_letrec) in
    Obj.repr(
# 186 "src/parser/tptp_parser.mly"
               ( _1 )
# 972 "src/parser/tptp_parser.ml"
               : 'thf_unitary_formula))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 1 : 'thf_logic_formula) in
    Obj.repr(
# 187 "src/parser/tptp_parser.mly"
                                    ( _2 )
# 979 "src/parser/tptp_parser.ml"
               : 'thf_unitary_formula))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 5 : 'thf_quantifier) in
    let _3 = (Parsing.peek_val __caml_parser_env 3 : 'thf_variable_list) in
    let _6 = (Parsing.peek_val __caml_parser_env 0 : 'thf_unitary_formula) in
    Obj.repr(
# 191 "src/parser/tptp_parser.mly"
    (Appl (Symbol "$$quantified", [_1;Appl (Symbol "$$tuple", _3);_6]))
# 988 "src/parser/tptp_parser.ml"
               : 'thf_quantified_formula))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'thf_variable) in
    Obj.repr(
# 194 "src/parser/tptp_parser.mly"
                 ( [ _1 ] )
# 995 "src/parser/tptp_parser.ml"
               : 'thf_variable_list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'thf_variable) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'thf_variable_list) in
    Obj.repr(
# 195 "src/parser/tptp_parser.mly"
                                         ( _1 :: _3 )
# 1003 "src/parser/tptp_parser.ml"
               : 'thf_variable_list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'variable) in
    Obj.repr(
# 198 "src/parser/tptp_parser.mly"
             ( _1 )
# 1010 "src/parser/tptp_parser.ml"
               : 'thf_variable))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'thf_typed_variable) in
    Obj.repr(
# 199 "src/parser/tptp_parser.mly"
                       ( _1 )
# 1017 "src/parser/tptp_parser.ml"
               : 'thf_variable))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'variable) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'thf_top_level_type) in
    Obj.repr(
# 202 "src/parser/tptp_parser.mly"
                                      ( Appl (Symbol "$$typed_var", [_1;_3]) )
# 1025 "src/parser/tptp_parser.ml"
               : 'thf_typed_variable))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 3 : 'thf_unary_connective) in
    let _3 = (Parsing.peek_val __caml_parser_env 1 : 'thf_logic_formula) in
    Obj.repr(
# 205 "src/parser/tptp_parser.mly"
                                                         ( Appl (_1, [_3]) )
# 1033 "src/parser/tptp_parser.ml"
               : 'thf_unary_formula))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'term) in
    Obj.repr(
# 208 "src/parser/tptp_parser.mly"
         ( _1 )
# 1040 "src/parser/tptp_parser.ml"
               : 'thf_atom))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'thf_conn_term) in
    Obj.repr(
# 209 "src/parser/tptp_parser.mly"
                  ( _1 )
# 1047 "src/parser/tptp_parser.ml"
               : 'thf_atom))
; (fun __caml_parser_env ->
    Obj.repr(
# 212 "src/parser/tptp_parser.mly"
                ( Appl (Symbol "$$tuple", []) )
# 1053 "src/parser/tptp_parser.ml"
               : 'thf_tuple))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 1 : 'thf_tuple_list) in
    Obj.repr(
# 213 "src/parser/tptp_parser.mly"
                               ( Appl (Symbol "$$tuple", _2) )
# 1060 "src/parser/tptp_parser.ml"
               : 'thf_tuple))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'thf_unitary_formula) in
    Obj.repr(
# 216 "src/parser/tptp_parser.mly"
                        ([ _1 ])
# 1067 "src/parser/tptp_parser.ml"
               : 'thf_tuple_list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'thf_unitary_formula) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'thf_tuple_list) in
    Obj.repr(
# 217 "src/parser/tptp_parser.mly"
                                             ( _1 :: _3 )
# 1075 "src/parser/tptp_parser.ml"
               : 'thf_tuple_list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'thf_unitary_formula) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'thf_top_level_type) in
    Obj.repr(
# 220 "src/parser/tptp_parser.mly"
                                                 ( Appl (Symbol "$$type_formula", [_1;_3]) )
# 1083 "src/parser/tptp_parser.ml"
               : 'thf_type_formula))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'constant) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'thf_top_level_type) in
    Obj.repr(
# 221 "src/parser/tptp_parser.mly"
                                      ( Appl (Symbol "$$type_formula", [_1;_3]) )
# 1091 "src/parser/tptp_parser.ml"
               : 'thf_type_formula))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'thf_logic_formula) in
    Obj.repr(
# 224 "src/parser/tptp_parser.mly"
                      ( _1 )
# 1098 "src/parser/tptp_parser.ml"
               : 'thf_top_level_type))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'thf_unitary_formula) in
    Obj.repr(
# 227 "src/parser/tptp_parser.mly"
                        ( _1 )
# 1105 "src/parser/tptp_parser.ml"
               : 'thf_unitary_type))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'thf_mapping_type) in
    Obj.repr(
# 230 "src/parser/tptp_parser.mly"
                     ( _1 )
# 1112 "src/parser/tptp_parser.ml"
               : 'thf_binary_type))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'thf_xprod_type) in
    Obj.repr(
# 231 "src/parser/tptp_parser.mly"
                   ( _1 )
# 1119 "src/parser/tptp_parser.ml"
               : 'thf_binary_type))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'thf_union_type) in
    Obj.repr(
# 232 "src/parser/tptp_parser.mly"
                   ( _1 )
# 1126 "src/parser/tptp_parser.ml"
               : 'thf_binary_type))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'thf_unitary_type) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'thf_unitary_type) in
    Obj.repr(
# 235 "src/parser/tptp_parser.mly"
                                            ( Appl (Symbol ">", [_1;_3]) )
# 1134 "src/parser/tptp_parser.ml"
               : 'thf_mapping_type))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'thf_unitary_type) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'thf_mapping_type) in
    Obj.repr(
# 236 "src/parser/tptp_parser.mly"
                                            ( Appl (Symbol ">", [_1;_3]) )
# 1142 "src/parser/tptp_parser.ml"
               : 'thf_mapping_type))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'thf_unitary_type) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'thf_unitary_type) in
    Obj.repr(
# 239 "src/parser/tptp_parser.mly"
                                           ( Appl (Symbol "*", [_1;_3]) )
# 1150 "src/parser/tptp_parser.ml"
               : 'thf_xprod_type))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'thf_xprod_type) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'thf_unitary_type) in
    Obj.repr(
# 240 "src/parser/tptp_parser.mly"
                                         ( Appl (Symbol "*", [_1;_3]) )
# 1158 "src/parser/tptp_parser.ml"
               : 'thf_xprod_type))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'thf_unitary_type) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'thf_unitary_type) in
    Obj.repr(
# 243 "src/parser/tptp_parser.mly"
                                           ( Appl (Symbol "+", [_1;_3]) )
# 1166 "src/parser/tptp_parser.ml"
               : 'thf_union_type))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'thf_union_type) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'thf_unitary_type) in
    Obj.repr(
# 244 "src/parser/tptp_parser.mly"
                                         ( Appl (Symbol "+", [_1;_3]) )
# 1174 "src/parser/tptp_parser.ml"
               : 'thf_union_type))
; (fun __caml_parser_env ->
    let _3 = (Parsing.peek_val __caml_parser_env 3 : 'thf_letrec_list) in
    let _6 = (Parsing.peek_val __caml_parser_env 0 : 'thf_unitary_formula) in
    Obj.repr(
# 247 "src/parser/tptp_parser.mly"
                                                                 ( Appl (Symbol "$$letrec", [Appl (Symbol "$$tuple", _3);_6]) )
# 1182 "src/parser/tptp_parser.ml"
               : 'thf_letrec))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'thf_defined_var) in
    Obj.repr(
# 250 "src/parser/tptp_parser.mly"
                    ( [_1] )
# 1189 "src/parser/tptp_parser.ml"
               : 'thf_letrec_list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'thf_defined_var) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'thf_letrec_list) in
    Obj.repr(
# 251 "src/parser/tptp_parser.mly"
                                          ( _1::_3 )
# 1197 "src/parser/tptp_parser.ml"
               : 'thf_letrec_list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'thf_variable) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'thf_logic_formula) in
    Obj.repr(
# 254 "src/parser/tptp_parser.mly"
                                          ( Appl (Symbol ":=", [_1;_3]) )
# 1205 "src/parser/tptp_parser.ml"
               : 'thf_defined_var))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 1 : 'thf_defined_var) in
    Obj.repr(
# 255 "src/parser/tptp_parser.mly"
                                  ( _2 )
# 1212 "src/parser/tptp_parser.ml"
               : 'thf_defined_var))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'thf_defn_constant) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'thf_logic_formula) in
    Obj.repr(
# 258 "src/parser/tptp_parser.mly"
                                               ( Appl (Symbol ":=", [_1;_3])  )
# 1220 "src/parser/tptp_parser.ml"
               : 'thf_definition))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 1 : 'thf_definition) in
    Obj.repr(
# 259 "src/parser/tptp_parser.mly"
                                 ( _2 )
# 1227 "src/parser/tptp_parser.ml"
               : 'thf_definition))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'constant) in
    Obj.repr(
# 262 "src/parser/tptp_parser.mly"
             ( _1 )
# 1234 "src/parser/tptp_parser.ml"
               : 'thf_defn_constant))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'thf_type_formula) in
    Obj.repr(
# 263 "src/parser/tptp_parser.mly"
                     ( _1 )
# 1241 "src/parser/tptp_parser.ml"
               : 'thf_defn_constant))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'thf_tuple) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'thf_tuple) in
    Obj.repr(
# 266 "src/parser/tptp_parser.mly"
                                  ( Appl (Symbol "-->", [_1;_3]) )
# 1249 "src/parser/tptp_parser.ml"
               : 'thf_sequent))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'binary_formula) in
    Obj.repr(
# 272 "src/parser/tptp_parser.mly"
                   ( _1 )
# 1256 "src/parser/tptp_parser.ml"
               : 'fof_formula))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'unitary_formula) in
    Obj.repr(
# 273 "src/parser/tptp_parser.mly"
                    ( _1 )
# 1263 "src/parser/tptp_parser.ml"
               : 'fof_formula))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'nonassoc_binary) in
    Obj.repr(
# 276 "src/parser/tptp_parser.mly"
                    ( _1 )
# 1270 "src/parser/tptp_parser.ml"
               : 'binary_formula))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'assoc_binary) in
    Obj.repr(
# 277 "src/parser/tptp_parser.mly"
                 ( _1 )
# 1277 "src/parser/tptp_parser.ml"
               : 'binary_formula))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'unitary_formula) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : 'binary_connective) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'unitary_formula) in
    Obj.repr(
# 280 "src/parser/tptp_parser.mly"
                                                      ( Appl (_2, [_1;_3]) )
# 1286 "src/parser/tptp_parser.ml"
               : 'nonassoc_binary))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'or_formula) in
    Obj.repr(
# 283 "src/parser/tptp_parser.mly"
               ( Appl (Symbol "|", _1) )
# 1293 "src/parser/tptp_parser.ml"
               : 'assoc_binary))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'and_formula) in
    Obj.repr(
# 284 "src/parser/tptp_parser.mly"
                ( Appl (Symbol "&", _1) )
# 1300 "src/parser/tptp_parser.ml"
               : 'assoc_binary))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'unitary_formula) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'unitary_formula) in
    Obj.repr(
# 287 "src/parser/tptp_parser.mly"
                                          ( [_1;_3] )
# 1308 "src/parser/tptp_parser.ml"
               : 'or_formula))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'or_formula) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'unitary_formula) in
    Obj.repr(
# 288 "src/parser/tptp_parser.mly"
                                     ( List.append _1 [_3] )
# 1316 "src/parser/tptp_parser.ml"
               : 'or_formula))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'unitary_formula) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'unitary_formula) in
    Obj.repr(
# 291 "src/parser/tptp_parser.mly"
                                              ( [_1;_3] )
# 1324 "src/parser/tptp_parser.ml"
               : 'and_formula))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'and_formula) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'unitary_formula) in
    Obj.repr(
# 292 "src/parser/tptp_parser.mly"
                                          ( List.append _1 [_3] )
# 1332 "src/parser/tptp_parser.ml"
               : 'and_formula))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'quantified_formula) in
    Obj.repr(
# 295 "src/parser/tptp_parser.mly"
                       ( _1 )
# 1339 "src/parser/tptp_parser.ml"
               : 'unitary_formula))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'unary_formula) in
    Obj.repr(
# 296 "src/parser/tptp_parser.mly"
                  ( _1 )
# 1346 "src/parser/tptp_parser.ml"
               : 'unitary_formula))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'atomic_formula) in
    Obj.repr(
# 297 "src/parser/tptp_parser.mly"
                   ( _1 )
# 1353 "src/parser/tptp_parser.ml"
               : 'unitary_formula))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 1 : 'fof_formula) in
    Obj.repr(
# 298 "src/parser/tptp_parser.mly"
                              ( _2 )
# 1360 "src/parser/tptp_parser.ml"
               : 'unitary_formula))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 5 : 'quantifier) in
    let _3 = (Parsing.peek_val __caml_parser_env 3 : 'variable_list) in
    let _6 = (Parsing.peek_val __caml_parser_env 0 : 'unitary_formula) in
    Obj.repr(
# 301 "src/parser/tptp_parser.mly"
                                                               ( Appl (Symbol "$$quantified", [_1;Appl (Symbol "$$tuple", _3);_6]) )
# 1369 "src/parser/tptp_parser.ml"
               : 'quantified_formula))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'variable) in
    Obj.repr(
# 304 "src/parser/tptp_parser.mly"
             ( [ _1 ] )
# 1376 "src/parser/tptp_parser.ml"
               : 'variable_list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'variable) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'variable_list) in
    Obj.repr(
# 305 "src/parser/tptp_parser.mly"
                                 ( _1 :: _3 )
# 1384 "src/parser/tptp_parser.ml"
               : 'variable_list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : 'unary_connective) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'unitary_formula) in
    Obj.repr(
# 308 "src/parser/tptp_parser.mly"
                                     ( Appl (_1, [_2]) )
# 1392 "src/parser/tptp_parser.ml"
               : 'unary_formula))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'fol_infix_unary) in
    Obj.repr(
# 309 "src/parser/tptp_parser.mly"
                    ( _1 )
# 1399 "src/parser/tptp_parser.ml"
               : 'unary_formula))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 1 : 'disjunction) in
    Obj.repr(
# 315 "src/parser/tptp_parser.mly"
                              ( Appl (Symbol "|", _2) )
# 1406 "src/parser/tptp_parser.ml"
               : 'cnf_formula))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'disjunction) in
    Obj.repr(
# 316 "src/parser/tptp_parser.mly"
                ( Appl (Symbol "|", _1) )
# 1413 "src/parser/tptp_parser.ml"
               : 'cnf_formula))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'literal) in
    Obj.repr(
# 319 "src/parser/tptp_parser.mly"
            ( [ _1 ] )
# 1420 "src/parser/tptp_parser.ml"
               : 'disjunction))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'disjunction) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'literal) in
    Obj.repr(
# 320 "src/parser/tptp_parser.mly"
                              ( List.append _1 [_3] )
# 1428 "src/parser/tptp_parser.ml"
               : 'disjunction))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'atomic_formula) in
    Obj.repr(
# 323 "src/parser/tptp_parser.mly"
                   ( Appl (Symbol "$$poslit", [_1]) )
# 1435 "src/parser/tptp_parser.ml"
               : 'literal))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'atomic_formula) in
    Obj.repr(
# 324 "src/parser/tptp_parser.mly"
                         ( Appl (Symbol "$$neglit", [_2]) )
# 1442 "src/parser/tptp_parser.ml"
               : 'literal))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'fol_infix_unary) in
    Obj.repr(
# 325 "src/parser/tptp_parser.mly"
                    ( Appl (Symbol "$$poslit", [_1]) )
# 1449 "src/parser/tptp_parser.ml"
               : 'literal))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'thf_unitary_formula) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : 'infix_inequality) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'thf_unitary_formula) in
    Obj.repr(
# 331 "src/parser/tptp_parser.mly"
                                                             ( Appl (_2, [_1;_3]) )
# 1458 "src/parser/tptp_parser.ml"
               : 'thf_infix_unary))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'thf_pair_connective) in
    Obj.repr(
# 334 "src/parser/tptp_parser.mly"
                        ( _1 )
# 1465 "src/parser/tptp_parser.ml"
               : 'thf_conn_term))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'assoc_connective) in
    Obj.repr(
# 335 "src/parser/tptp_parser.mly"
                     ( _1 )
# 1472 "src/parser/tptp_parser.ml"
               : 'thf_conn_term))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'thf_unary_connective) in
    Obj.repr(
# 336 "src/parser/tptp_parser.mly"
                         ( _1 )
# 1479 "src/parser/tptp_parser.ml"
               : 'thf_conn_term))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'term) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : 'infix_inequality) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'term) in
    Obj.repr(
# 339 "src/parser/tptp_parser.mly"
                               ( Appl (_2, [_1;_3]) )
# 1488 "src/parser/tptp_parser.ml"
               : 'fol_infix_unary))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'quantifier) in
    Obj.repr(
# 345 "src/parser/tptp_parser.mly"
               ( _1 )
# 1495 "src/parser/tptp_parser.ml"
               : 'thf_quantifier))
; (fun __caml_parser_env ->
    Obj.repr(
# 346 "src/parser/tptp_parser.mly"
          ( Symbol "^" )
# 1501 "src/parser/tptp_parser.ml"
               : 'thf_quantifier))
; (fun __caml_parser_env ->
    Obj.repr(
# 347 "src/parser/tptp_parser.mly"
           ( Symbol "@+" )
# 1507 "src/parser/tptp_parser.ml"
               : 'thf_quantifier))
; (fun __caml_parser_env ->
    Obj.repr(
# 348 "src/parser/tptp_parser.mly"
       ( Symbol "!>" )
# 1513 "src/parser/tptp_parser.ml"
               : 'thf_quantifier))
; (fun __caml_parser_env ->
    Obj.repr(
# 349 "src/parser/tptp_parser.mly"
          ( Symbol "?*" )
# 1519 "src/parser/tptp_parser.ml"
               : 'thf_quantifier))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'infix_equality) in
    Obj.repr(
# 352 "src/parser/tptp_parser.mly"
                   ( _1 )
# 1526 "src/parser/tptp_parser.ml"
               : 'thf_pair_connective))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'binary_connective) in
    Obj.repr(
# 353 "src/parser/tptp_parser.mly"
                      ( _1 )
# 1533 "src/parser/tptp_parser.ml"
               : 'thf_pair_connective))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'unary_connective) in
    Obj.repr(
# 356 "src/parser/tptp_parser.mly"
                     ( _1 )
# 1540 "src/parser/tptp_parser.ml"
               : 'thf_unary_connective))
; (fun __caml_parser_env ->
    Obj.repr(
# 357 "src/parser/tptp_parser.mly"
            ( Symbol "!!" )
# 1546 "src/parser/tptp_parser.ml"
               : 'thf_unary_connective))
; (fun __caml_parser_env ->
    Obj.repr(
# 358 "src/parser/tptp_parser.mly"
            ( Symbol "??" )
# 1552 "src/parser/tptp_parser.ml"
               : 'thf_unary_connective))
; (fun __caml_parser_env ->
    Obj.repr(
# 364 "src/parser/tptp_parser.mly"
             ( Symbol "?" )
# 1558 "src/parser/tptp_parser.ml"
               : 'quantifier))
; (fun __caml_parser_env ->
    Obj.repr(
# 365 "src/parser/tptp_parser.mly"
                ( Symbol "!" )
# 1564 "src/parser/tptp_parser.ml"
               : 'quantifier))
; (fun __caml_parser_env ->
    Obj.repr(
# 368 "src/parser/tptp_parser.mly"
        ( Symbol "<=>" )
# 1570 "src/parser/tptp_parser.ml"
               : 'binary_connective))
; (fun __caml_parser_env ->
    Obj.repr(
# 369 "src/parser/tptp_parser.mly"
            ( Symbol "=>" )
# 1576 "src/parser/tptp_parser.ml"
               : 'binary_connective))
; (fun __caml_parser_env ->
    Obj.repr(
# 370 "src/parser/tptp_parser.mly"
       ( Symbol "<=" )
# 1582 "src/parser/tptp_parser.ml"
               : 'binary_connective))
; (fun __caml_parser_env ->
    Obj.repr(
# 371 "src/parser/tptp_parser.mly"
         ( Symbol "<~>" )
# 1588 "src/parser/tptp_parser.ml"
               : 'binary_connective))
; (fun __caml_parser_env ->
    Obj.repr(
# 372 "src/parser/tptp_parser.mly"
        ( Symbol "~|" )
# 1594 "src/parser/tptp_parser.ml"
               : 'binary_connective))
; (fun __caml_parser_env ->
    Obj.repr(
# 373 "src/parser/tptp_parser.mly"
         ( Symbol "~&" )
# 1600 "src/parser/tptp_parser.ml"
               : 'binary_connective))
; (fun __caml_parser_env ->
    Obj.repr(
# 376 "src/parser/tptp_parser.mly"
          ( Symbol "|" )
# 1606 "src/parser/tptp_parser.ml"
               : 'assoc_connective))
; (fun __caml_parser_env ->
    Obj.repr(
# 377 "src/parser/tptp_parser.mly"
              ( Symbol "&" )
# 1612 "src/parser/tptp_parser.ml"
               : 'assoc_connective))
; (fun __caml_parser_env ->
    Obj.repr(
# 380 "src/parser/tptp_parser.mly"
          ( Symbol "~" )
# 1618 "src/parser/tptp_parser.ml"
               : 'unary_connective))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'atomic_defined_word) in
    Obj.repr(
# 387 "src/parser/tptp_parser.mly"
                        ( _1 )
# 1625 "src/parser/tptp_parser.ml"
               : 'defined_type))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'atomic_system_word) in
    Obj.repr(
# 390 "src/parser/tptp_parser.mly"
                       ( _1 )
# 1632 "src/parser/tptp_parser.ml"
               : 'system_type))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'plain_atomic_formula) in
    Obj.repr(
# 396 "src/parser/tptp_parser.mly"
                         ( _1 )
# 1639 "src/parser/tptp_parser.ml"
               : 'atomic_formula))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'defined_atomic_formula) in
    Obj.repr(
# 397 "src/parser/tptp_parser.mly"
                           ( _1 )
# 1646 "src/parser/tptp_parser.ml"
               : 'atomic_formula))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'system_atomic_formula) in
    Obj.repr(
# 398 "src/parser/tptp_parser.mly"
                          ( _1 )
# 1653 "src/parser/tptp_parser.ml"
               : 'atomic_formula))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'plain_term) in
    Obj.repr(
# 401 "src/parser/tptp_parser.mly"
               ( _1 )
# 1660 "src/parser/tptp_parser.ml"
               : 'plain_atomic_formula))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'defined_plain_formula) in
    Obj.repr(
# 404 "src/parser/tptp_parser.mly"
                          ( _1 )
# 1667 "src/parser/tptp_parser.ml"
               : 'defined_atomic_formula))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'defined_infix_formula) in
    Obj.repr(
# 405 "src/parser/tptp_parser.mly"
                          ( _1 )
# 1674 "src/parser/tptp_parser.ml"
               : 'defined_atomic_formula))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'defined_plain_term) in
    Obj.repr(
# 408 "src/parser/tptp_parser.mly"
                       ( _1 )
# 1681 "src/parser/tptp_parser.ml"
               : 'defined_plain_formula))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'term) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : 'defined_infix_pred) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'term) in
    Obj.repr(
# 411 "src/parser/tptp_parser.mly"
                                 ( Appl (_2, [_1;_3]) )
# 1690 "src/parser/tptp_parser.ml"
               : 'defined_infix_formula))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'infix_equality) in
    Obj.repr(
# 414 "src/parser/tptp_parser.mly"
                   ( _1 )
# 1697 "src/parser/tptp_parser.ml"
               : 'defined_infix_pred))
; (fun __caml_parser_env ->
    Obj.repr(
# 417 "src/parser/tptp_parser.mly"
          ( Symbol "=" )
# 1703 "src/parser/tptp_parser.ml"
               : 'infix_equality))
; (fun __caml_parser_env ->
    Obj.repr(
# 420 "src/parser/tptp_parser.mly"
           ( Symbol "!=" )
# 1709 "src/parser/tptp_parser.ml"
               : 'infix_inequality))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'system_term) in
    Obj.repr(
# 423 "src/parser/tptp_parser.mly"
                ( _1 )
# 1716 "src/parser/tptp_parser.ml"
               : 'system_atomic_formula))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'function_term) in
    Obj.repr(
# 429 "src/parser/tptp_parser.mly"
                  ( _1 )
# 1723 "src/parser/tptp_parser.ml"
               : 'term))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'variable) in
    Obj.repr(
# 430 "src/parser/tptp_parser.mly"
             ( _1 )
# 1730 "src/parser/tptp_parser.ml"
               : 'term))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'plain_term) in
    Obj.repr(
# 433 "src/parser/tptp_parser.mly"
               ( _1 )
# 1737 "src/parser/tptp_parser.ml"
               : 'function_term))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'defined_term) in
    Obj.repr(
# 434 "src/parser/tptp_parser.mly"
                 ( _1 )
# 1744 "src/parser/tptp_parser.ml"
               : 'function_term))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'system_term) in
    Obj.repr(
# 435 "src/parser/tptp_parser.mly"
                ( _1 )
# 1751 "src/parser/tptp_parser.ml"
               : 'function_term))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'constant) in
    Obj.repr(
# 438 "src/parser/tptp_parser.mly"
             ( _1 )
# 1758 "src/parser/tptp_parser.ml"
               : 'plain_term))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 3 : 'fof_functor) in
    let _3 = (Parsing.peek_val __caml_parser_env 1 : 'arguments) in
    Obj.repr(
# 439 "src/parser/tptp_parser.mly"
                                        ( Appl (_1, _3) )
# 1766 "src/parser/tptp_parser.ml"
               : 'plain_term))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'fof_functor) in
    Obj.repr(
# 442 "src/parser/tptp_parser.mly"
                ( _1 )
# 1773 "src/parser/tptp_parser.ml"
               : 'constant))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'atomic_word) in
    Obj.repr(
# 445 "src/parser/tptp_parser.mly"
                ( _1 )
# 1780 "src/parser/tptp_parser.ml"
               : 'fof_functor))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'defined_atom) in
    Obj.repr(
# 448 "src/parser/tptp_parser.mly"
                 ( _1 )
# 1787 "src/parser/tptp_parser.ml"
               : 'defined_term))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'defined_atomic_term) in
    Obj.repr(
# 449 "src/parser/tptp_parser.mly"
                        ( _1 )
# 1794 "src/parser/tptp_parser.ml"
               : 'defined_term))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'number) in
    Obj.repr(
# 452 "src/parser/tptp_parser.mly"
           ( _1 )
# 1801 "src/parser/tptp_parser.ml"
               : 'defined_atom))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : string) in
    Obj.repr(
# 453 "src/parser/tptp_parser.mly"
                    ( Symbol _1 )
# 1808 "src/parser/tptp_parser.ml"
               : 'defined_atom))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'defined_plain_term) in
    Obj.repr(
# 456 "src/parser/tptp_parser.mly"
                       ( _1 )
# 1815 "src/parser/tptp_parser.ml"
               : 'defined_atomic_term))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'defined_constant) in
    Obj.repr(
# 459 "src/parser/tptp_parser.mly"
                     ( _1 )
# 1822 "src/parser/tptp_parser.ml"
               : 'defined_plain_term))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 3 : 'defined_functor) in
    let _3 = (Parsing.peek_val __caml_parser_env 1 : 'arguments) in
    Obj.repr(
# 460 "src/parser/tptp_parser.mly"
                                            ( Appl (_1, _3) )
# 1830 "src/parser/tptp_parser.ml"
               : 'defined_plain_term))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'defined_functor) in
    Obj.repr(
# 463 "src/parser/tptp_parser.mly"
                    ( _1 )
# 1837 "src/parser/tptp_parser.ml"
               : 'defined_constant))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'atomic_defined_word) in
    Obj.repr(
# 466 "src/parser/tptp_parser.mly"
                        ( _1 )
# 1844 "src/parser/tptp_parser.ml"
               : 'defined_functor))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'system_constant) in
    Obj.repr(
# 469 "src/parser/tptp_parser.mly"
                    ( _1 )
# 1851 "src/parser/tptp_parser.ml"
               : 'system_term))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 3 : 'system_functor) in
    let _3 = (Parsing.peek_val __caml_parser_env 1 : 'arguments) in
    Obj.repr(
# 470 "src/parser/tptp_parser.mly"
                                           ( Appl (_1, _3) )
# 1859 "src/parser/tptp_parser.ml"
               : 'system_term))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'system_functor) in
    Obj.repr(
# 473 "src/parser/tptp_parser.mly"
                   ( _1 )
# 1866 "src/parser/tptp_parser.ml"
               : 'system_constant))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'atomic_system_word) in
    Obj.repr(
# 476 "src/parser/tptp_parser.mly"
                       ( _1 )
# 1873 "src/parser/tptp_parser.ml"
               : 'system_functor))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : string) in
    Obj.repr(
# 479 "src/parser/tptp_parser.mly"
               ( Symbol _1 )
# 1880 "src/parser/tptp_parser.ml"
               : 'variable))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'term) in
    Obj.repr(
# 482 "src/parser/tptp_parser.mly"
         ( [_1] )
# 1887 "src/parser/tptp_parser.ml"
               : 'arguments))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'term) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'arguments) in
    Obj.repr(
# 483 "src/parser/tptp_parser.mly"
                         ( _1::_3 )
# 1895 "src/parser/tptp_parser.ml"
               : 'arguments))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'general_term) in
    Obj.repr(
# 489 "src/parser/tptp_parser.mly"
                 ( _1 )
# 1902 "src/parser/tptp_parser.ml"
               : 'source))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'general_data) in
    Obj.repr(
# 492 "src/parser/tptp_parser.mly"
                 ( _1 )
# 1909 "src/parser/tptp_parser.ml"
               : 'general_term))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'general_data) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'general_term) in
    Obj.repr(
# 493 "src/parser/tptp_parser.mly"
                                    ( Appl (Symbol ":", [_1;_3]) )
# 1917 "src/parser/tptp_parser.ml"
               : 'general_term))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'general_list) in
    Obj.repr(
# 494 "src/parser/tptp_parser.mly"
                 ( Appl (Symbol "$$tuple", _1) )
# 1924 "src/parser/tptp_parser.ml"
               : 'general_term))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'atomic_word) in
    Obj.repr(
# 497 "src/parser/tptp_parser.mly"
                ( _1 )
# 1931 "src/parser/tptp_parser.ml"
               : 'general_data))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 3 : 'atomic_word) in
    let _3 = (Parsing.peek_val __caml_parser_env 1 : 'general_terms) in
    Obj.repr(
# 498 "src/parser/tptp_parser.mly"
                                            ( Appl (_1, _3) )
# 1939 "src/parser/tptp_parser.ml"
               : 'general_data))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'variable) in
    Obj.repr(
# 499 "src/parser/tptp_parser.mly"
             ( _1 )
# 1946 "src/parser/tptp_parser.ml"
               : 'general_data))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'number) in
    Obj.repr(
# 500 "src/parser/tptp_parser.mly"
           ( _1 )
# 1953 "src/parser/tptp_parser.ml"
               : 'general_data))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Formula.formula) in
    Obj.repr(
# 501 "src/parser/tptp_parser.mly"
                 ( _1 )
# 1960 "src/parser/tptp_parser.ml"
               : 'general_data))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : string) in
    Obj.repr(
# 502 "src/parser/tptp_parser.mly"
                    ( Symbol _1 )
# 1967 "src/parser/tptp_parser.ml"
               : 'general_data))
; (fun __caml_parser_env ->
    let _3 = (Parsing.peek_val __caml_parser_env 1 : 'thf_formula) in
    Obj.repr(
# 505 "src/parser/tptp_parser.mly"
                                         ( Appl (Symbol "$thf", [_3]) )
# 1974 "src/parser/tptp_parser.ml"
               : Formula.formula))
; (fun __caml_parser_env ->
    let _3 = (Parsing.peek_val __caml_parser_env 1 : 'fof_formula) in
    Obj.repr(
# 506 "src/parser/tptp_parser.mly"
                                         ( Appl (Symbol "$fof", [_3]) )
# 1981 "src/parser/tptp_parser.ml"
               : Formula.formula))
; (fun __caml_parser_env ->
    let _3 = (Parsing.peek_val __caml_parser_env 1 : 'cnf_formula) in
    Obj.repr(
# 507 "src/parser/tptp_parser.mly"
                                         ( Appl (Symbol "$cnf", [_3]) )
# 1988 "src/parser/tptp_parser.ml"
               : Formula.formula))
; (fun __caml_parser_env ->
    let _3 = (Parsing.peek_val __caml_parser_env 1 : 'term) in
    Obj.repr(
# 508 "src/parser/tptp_parser.mly"
                                  ( Appl (Symbol "$fot", [_3]) )
# 1995 "src/parser/tptp_parser.ml"
               : Formula.formula))
; (fun __caml_parser_env ->
    Obj.repr(
# 511 "src/parser/tptp_parser.mly"
                ( [] )
# 2001 "src/parser/tptp_parser.ml"
               : 'general_list))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 1 : 'general_terms) in
    Obj.repr(
# 512 "src/parser/tptp_parser.mly"
                              ( _2 )
# 2008 "src/parser/tptp_parser.ml"
               : 'general_list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'general_term) in
    Obj.repr(
# 515 "src/parser/tptp_parser.mly"
                 ( [_1] )
# 2015 "src/parser/tptp_parser.ml"
               : 'general_terms))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'general_term) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'general_terms) in
    Obj.repr(
# 516 "src/parser/tptp_parser.mly"
                                     (_1::_3 )
# 2023 "src/parser/tptp_parser.ml"
               : 'general_terms))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'useful_info) in
    Obj.repr(
# 519 "src/parser/tptp_parser.mly"
                      ( Appl (Symbol "$$useful_info", [_2]) )
# 2030 "src/parser/tptp_parser.ml"
               : 'optional_info))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'null) in
    Obj.repr(
# 520 "src/parser/tptp_parser.mly"
         ( _1 )
# 2037 "src/parser/tptp_parser.ml"
               : 'optional_info))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'general_list) in
    Obj.repr(
# 523 "src/parser/tptp_parser.mly"
                 ( Appl (Symbol "$$tuple", _1) )
# 2044 "src/parser/tptp_parser.ml"
               : 'useful_info))
; (fun __caml_parser_env ->
    let _3 = (Parsing.peek_val __caml_parser_env 3 : 'file_name) in
    let _4 = (Parsing.peek_val __caml_parser_env 2 : 'formula_selection) in
    Obj.repr(
# 529 "src/parser/tptp_parser.mly"
                                                             ( Appl (Symbol "$$include", [_3;_4]) )
# 2052 "src/parser/tptp_parser.ml"
               : 'file_include))
; (fun __caml_parser_env ->
    let _3 = (Parsing.peek_val __caml_parser_env 1 : 'name_list) in
    Obj.repr(
# 533 "src/parser/tptp_parser.mly"
                                ( Appl (Symbol "$$formula_selection", [Appl (Symbol "$$tuple",_3)]) )
# 2059 "src/parser/tptp_parser.ml"
               : 'formula_selection))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'null) in
    Obj.repr(
# 534 "src/parser/tptp_parser.mly"
         ( _1 )
# 2066 "src/parser/tptp_parser.ml"
               : 'formula_selection))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'name) in
    Obj.repr(
# 537 "src/parser/tptp_parser.mly"
         ( [_1] )
# 2073 "src/parser/tptp_parser.ml"
               : 'name_list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'name) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'name_list) in
    Obj.repr(
# 538 "src/parser/tptp_parser.mly"
                         ( _1::_3 )
# 2081 "src/parser/tptp_parser.ml"
               : 'name_list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'atomic_word) in
    Obj.repr(
# 546 "src/parser/tptp_parser.mly"
                (_1)
# 2088 "src/parser/tptp_parser.ml"
               : 'name))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : string) in
    Obj.repr(
# 547 "src/parser/tptp_parser.mly"
                     (Symbol _1)
# 2095 "src/parser/tptp_parser.ml"
               : 'name))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : string) in
    Obj.repr(
# 550 "src/parser/tptp_parser.mly"
               ( Symbol _1 )
# 2102 "src/parser/tptp_parser.ml"
               : 'atomic_word))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : string) in
    Obj.repr(
# 551 "src/parser/tptp_parser.mly"
                  ( Symbol _1 )
# 2109 "src/parser/tptp_parser.ml"
               : 'atomic_word))
; (fun __caml_parser_env ->
    Obj.repr(
# 552 "src/parser/tptp_parser.mly"
        ( Symbol "thf" )
# 2115 "src/parser/tptp_parser.ml"
               : 'atomic_word))
; (fun __caml_parser_env ->
    Obj.repr(
# 553 "src/parser/tptp_parser.mly"
        ( Symbol "fof" )
# 2121 "src/parser/tptp_parser.ml"
               : 'atomic_word))
; (fun __caml_parser_env ->
    Obj.repr(
# 554 "src/parser/tptp_parser.mly"
        ( Symbol "cnf" )
# 2127 "src/parser/tptp_parser.ml"
               : 'atomic_word))
; (fun __caml_parser_env ->
    Obj.repr(
# 555 "src/parser/tptp_parser.mly"
            ( Symbol "include" )
# 2133 "src/parser/tptp_parser.ml"
               : 'atomic_word))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : string) in
    Obj.repr(
# 558 "src/parser/tptp_parser.mly"
                ( Symbol _1 )
# 2140 "src/parser/tptp_parser.ml"
               : 'atomic_defined_word))
; (fun __caml_parser_env ->
    Obj.repr(
# 559 "src/parser/tptp_parser.mly"
               ( Symbol "$thf" )
# 2146 "src/parser/tptp_parser.ml"
               : 'atomic_defined_word))
; (fun __caml_parser_env ->
    Obj.repr(
# 560 "src/parser/tptp_parser.mly"
               ( Symbol "$fof" )
# 2152 "src/parser/tptp_parser.ml"
               : 'atomic_defined_word))
; (fun __caml_parser_env ->
    Obj.repr(
# 561 "src/parser/tptp_parser.mly"
               ( Symbol "$cnf" )
# 2158 "src/parser/tptp_parser.ml"
               : 'atomic_defined_word))
; (fun __caml_parser_env ->
    Obj.repr(
# 562 "src/parser/tptp_parser.mly"
               ( Symbol "$fot" )
# 2164 "src/parser/tptp_parser.ml"
               : 'atomic_defined_word))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : string) in
    Obj.repr(
# 565 "src/parser/tptp_parser.mly"
                       ( Symbol _1 )
# 2171 "src/parser/tptp_parser.ml"
               : 'atomic_system_word))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : string) in
    Obj.repr(
# 568 "src/parser/tptp_parser.mly"
         ( Symbol _1 )
# 2178 "src/parser/tptp_parser.ml"
               : 'number))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : string) in
    Obj.repr(
# 569 "src/parser/tptp_parser.mly"
                   ( Symbol _1 )
# 2185 "src/parser/tptp_parser.ml"
               : 'number))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : string) in
    Obj.repr(
# 570 "src/parser/tptp_parser.mly"
                     ( Symbol _1 )
# 2192 "src/parser/tptp_parser.ml"
               : 'number))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : string) in
    Obj.repr(
# 573 "src/parser/tptp_parser.mly"
                  ( Symbol _1 )
# 2199 "src/parser/tptp_parser.ml"
               : 'file_name))
; (fun __caml_parser_env ->
    Obj.repr(
# 575 "src/parser/tptp_parser.mly"
       ( Appl (Symbol "$$null",[]) )
# 2205 "src/parser/tptp_parser.ml"
               : 'null))
(* Entry tptp_file *)
; (fun __caml_parser_env -> raise (Parsing.YYexit (Parsing.peek_val __caml_parser_env 0)))
(* Entry tptp_input *)
; (fun __caml_parser_env -> raise (Parsing.YYexit (Parsing.peek_val __caml_parser_env 0)))
(* Entry formula_data *)
; (fun __caml_parser_env -> raise (Parsing.YYexit (Parsing.peek_val __caml_parser_env 0)))
|]
let yytables =
  { Parsing.actions=yyact;
    Parsing.transl_const=yytransl_const;
    Parsing.transl_block=yytransl_block;
    Parsing.lhs=yylhs;
    Parsing.len=yylen;
    Parsing.defred=yydefred;
    Parsing.dgoto=yydgoto;
    Parsing.sindex=yysindex;
    Parsing.rindex=yyrindex;
    Parsing.gindex=yygindex;
    Parsing.tablesize=yytablesize;
    Parsing.table=yytable;
    Parsing.check=yycheck;
    Parsing.error_function=parse_error;
    Parsing.names_const=yynames_const;
    Parsing.names_block=yynames_block }
let tptp_file (lexfun : Lexing.lexbuf -> token) (lexbuf : Lexing.lexbuf) =
   (Parsing.yyparse yytables 1 lexfun lexbuf : Formula.formula list)
let tptp_input (lexfun : Lexing.lexbuf -> token) (lexbuf : Lexing.lexbuf) =
   (Parsing.yyparse yytables 2 lexfun lexbuf : Formula.formula)
let formula_data (lexfun : Lexing.lexbuf -> token) (lexbuf : Lexing.lexbuf) =
   (Parsing.yyparse yytables 3 lexfun lexbuf : Formula.formula)
