open State
open Search
open String
open Syntax
open Refutation

let lpar p = if p then "(" else ""

let rpar p = if p then ")" else ""      
      
let rec stp_lat_rec a p =
  match a with
    Base(x) -> escaped x 
  | Prop -> "o"
  | Ar(b,c) -> (lpar p) ^ (stp_lat_rec b true) ^ "" ^ (stp_lat_rec c false) ^ (rpar p)

let stp_str a = stp_lat_rec a false      
   
let escaped s = let r = ref "" in
   String.iter (fun c ->  if c = '_' or c = '^' or c = '$' then r := !r^"\\"^(make 1 c) else r := !r^(make 1 c) ) s;
   !r
  
let rec trm_lat_rec m lp rp =
  match m with
  | Ap(Neg,y) ->  begin
    	match y with
            | Ap(Ap(Eq(a),x1),x2) ->
              if ((lp < 40) && (rp < 40)) 
              then	(trm_lat_rec x1 lp 40) ^" \\neq "^ (trm_lat_rec x2 40 rp)
              else  "("^(trm_lat_rec x1 (-1) 40) ^" \\neq "^ (trm_lat_rec x2 40 (-1))^")"
            | False -> "\\top "
            | _ ->
              if ((lp < 0) && (rp < 30)) 
              then   "\\neg " ^ trm_lat_rec y 30 rp
              else  "(\\neg " ^ trm_lat_rec y 30 (-1) ^ ")"
    end
  | Ap(Ap(Imp,y),False)  -> 
    begin
    	match y with
            | Ap(Ap(Eq(a),x1),x2) ->
              if ((lp < 40) && (rp < 40)) 
              then	(trm_lat_rec x1 lp 40) ^" \\neq "^ (trm_lat_rec x2 40 rp)
              else  "("^(trm_lat_rec x1 (-1) 40) ^" \\neq "^ (trm_lat_rec x2 40 (-1))^")"
            | False -> "\\top "
            | _ ->
              if ((lp < 0) && (rp < 30)) 
              then   "\\neg " ^ trm_lat_rec y 30 rp
              else  "(\\neg " ^ trm_lat_rec y 30 (-1) ^ ")"
    end
  | Ap(Forall(a),Lam(_,m)) ->
     if ((lp < 0) && (rp < 0)) 
     then "\\forall "^ trm_lat_rec m (-1) (-1)
     else "( \\forall "^ trm_lat_rec m (-1) (-1)^")"
  | Ap(Forall(a),m) ->   (* Notloesung *)
     if ((lp < 0) && (rp < 0)) 
     then "\\forall "^ trm_lat_rec (Ap (shift m 0 1, DB(0,a)))(-1) (-1)
     else "( \\forall "^ trm_lat_rec m (-1) (-1)^")"   
  | Ap(Exists(a),m) ->
      if ((lp < 0) && (rp < 0)) 
      then "\\exists "^trm_lat_rec m (-1) (-1)
      else "(\\exists "^ trm_lat_rec m (-1) (-1)^")";     
  | Ap(Ap(Imp,x),y) ->
     if ((lp < 17) && (rp < 16)) 
     then  trm_lat_rec x lp 17^" \\rightarrow "^ trm_lat_rec y 16 rp 
     else "("^ trm_lat_rec x (-1) 17^" \\rightarrow "^ trm_lat_rec y 16 (-1)^ ")"
  | Ap(Ap(And,m1),m2) ->
      if ((lp < 20) && (rp < 21)) 
      then trm_lat_rec m1  lp 20 ^ " \\wedge "^ trm_lat_rec m2  21 rp
	  else "("^ trm_lat_rec m1  (-1) 20^ " \\wedge "^ trm_lat_rec m2  21 (-1)^")"
  | Ap(Ap(Or,m1),m2) ->
      if ((lp < 18) && (rp < 19)) 
      then trm_lat_rec m1  lp 18^ " \\vee "^ trm_lat_rec m2  19 rp
	  else "("^ trm_lat_rec m1 (-1) 18^" \\vee "^trm_lat_rec m2  19 (-1)^ ")"
  | Ap(Ap(Iff,m1),m2) ->
      if ((lp < 14) && (rp < 14)) 
      then trm_lat_rec m1  lp 14^ " \\leftrightarrow "^ trm_lat_rec m2  14 rp
      else "("^trm_lat_rec m1 (-1) 14^" \\leftrightarrow "^ trm_lat_rec m2  14 (-1)^")"	       
  | Ap(Ap(Eq(a),x1),x2) ->
    if ((lp < 40) && (rp < 40)) 
    then	(trm_lat_rec x1 lp 40) ^" = "^ (trm_lat_rec x2 40 rp)
              else  "("^(trm_lat_rec x1 (-1) 40) ^" = "^ (trm_lat_rec x2 40 (-1))^")"
  | Name(x,_) -> escaped x 
  | False -> "\\bot"
  | True -> "\\top"  
  | Imp -> "\\rightarrow"
  | Iff -> "\\leftrightarrow"
  | And -> "\\wedge"
  | Or  -> "\\vee" 
  | Neg -> "\\neg "
  | Forall(_) -> "\\forall"
  | Exists(_) -> "\\exists"  
  | Eq(_) -> "="
  | Choice(_) -> "\\varepsilon"
  | DB(i,_) -> " \\hat{" ^ (string_of_int i) ^"}"
  | Lam(a,m) -> 
     if ((lp < 0) && (rp < 0)) 
     then "\\lambda:" ^ (stp_str a) ^ "." ^ trm_lat_rec m (-1) (-1)
	 else "( \\lambda:" ^ (stp_str a) ^ "." ^ trm_lat_rec m  (-1) (-1)^")"
  | Ap(m1,m2) ->
    if ((lp < 5000) && (rp < 5001)) 
    then trm_lat_rec m1 lp 5000^ " ~ "^trm_lat_rec m2 5001 rp
    else "("^trm_lat_rec m1 (-1) 5000^ " ~ "^trm_lat_rec m2 5001 (-1)^")"

let trm_lat m = "$" ^trm_lat_rec m (-1) (-1) ^ "$"
  
let rec cformat n =  if n =0 then "" else "|c" ^ cformat (n-1) 
  
let rec ref_lat r =
  match r with
 | Conflict(s,ns) -> "$\\lightning$"
 | Fal(s) -> "$\\lightning$"
 | NegRefl(s) -> "$\\lightning$"
 | Implication(h,s,t,r1,r2) -> "\\begin{tabular}{c|c} \n " 
   								^"\\textcolor[rgb]{0, 0, 1}{$\\mathcal T _{\\rightarrow}$} ~~" ^ (trm_lat s) ^" & "^ (trm_lat t)^ " \\\\ \n"
   								^ ref_lat r1 ^" & \n"^ ref_lat r2 ^" \\\\ \n"
   								^ "\\end{tabular} \n " 
 | NegImplication(h,s,r1) ->"\\begin{tabular}{c} \n " 
   								^"\\textcolor[rgb]{0, 0, 1}{$\\mathcal T _{\\neg \\rightarrow}$} ~~"^ (trm_lat s) ^ " \\\\ \n"
   								^ ref_lat r1  ^" \\\\ \n"
   								^ "\\end{tabular} \n " 
 | All(h,s,r1) ->"\\begin{tabular}{c} \n " 
   								^"\\textcolor[rgb]{0, 0, 1}{$\\mathcal T _{\\forall}$} ~~" ^ (trm_lat s) ^ " \\\\ \n"
   								^ ref_lat r1  ^" \\\\ \n"
   								^ "\\end{tabular} \n " 
 | NegAll(h,s,r1) ->"\\begin{tabular}{c} \n " 
   								^"\\textcolor[rgb]{0, 0, 1}{$\\mathcal T _{\\neg \\forall}$} ~~" ^ (trm_lat s) ^ " \\\\ \n"
   								^ ref_lat r1  ^" \\\\ \n"
   								^ "\\end{tabular} \n " 
 | Mating(h1,h2, ss, rs) -> "\\begin{tabular}{" ^(String.concat "|" (List.map (fun s->"c") ss))^ "} \n " 
   								^"\\textcolor[rgb]{0, 0, 1}{$\\mathcal T _{MAT}$} ~~" ^ (String.concat " & " (List.map (fun s  -> trm_lat s ) ss)) ^" \\\\ \n"
   								^ (String.concat " & \n" (List.map (fun r  ->ref_lat r ) rs)) ^" \\\\ \n"
   								^ "\\end{tabular} \n " 
 | Confront(h1,h2,s,t,r1,r2) ->"\\begin{tabular}{c|c} \n " 
   								^ (trm_lat s) ^" & "^ (trm_lat t)^ " \\\\ \n"
   								^ ref_lat r1 ^" & \n"^ ref_lat r2 ^" \\\\ \n"
   								^ "\\end{tabular} \n" 
 | Cut(s,r1,r2) -> "\\begin{tabular}{c|c} \n \\textcolor[rgb]{1, 0, 0}{" 
   								^ (trm_lat s) ^"} & \\textcolor[rgb]{1, 0, 0}{"^ (trm_lat (neg s))^ "} \\\\ \n"
   								^ ref_lat r1 ^" & \n"^ ref_lat r2 ^" \\\\ \n"
   								^ "\\end{tabular} \n "     
       
let rec ref_lat1 ts r = match ts with
  | [] -> ref_lat r
  | (t::tr) -> trm_lat (literal_to_trm t) ^ " \\\\ \n" ^ ref_lat1 tr r 
  
 (**
let rec pretrm_lat_rec m lp rp =
  match m with
  | PName x -> escaped x
  | PType -> "SType"
  | PPropTp -> "o"
  | PIndTp -> "\\$i"
  | PTrue ->  "\\top"
  | PFalse -> "\\bot"
  | PAp(PNeg,m1) ->
      if ((lp < 0) && (rp < 30)) 
      then "\\neg "^ pretrm_lat_rec m1 30 rp
      else "(\\neg "^ pretrm_lat_rec m1 30 (-1)^")"
  | PAp(PForall,m1) ->
      if ((lp < 0) && (rp < 0)) 
      then "\\forall "^ pretrm_lat_rec m1 (-1) (-1)
	  else "(\\forall "^ pretrm_lat_rec m1 (-1) (-1)^ ")"	
  | PAp(PExists,m1) ->
      if ((lp < 0) && (rp < 0)) 
      then "\\exists "^pretrm_lat_rec m1 (-1) (-1)
      else "(\\exists "^ pretrm_lat_rec m1 (-1) (-1)^")";
  | PAp(PAp(PImplies,m1),m2) ->
      if ((lp < 17) && (rp < 16)) 
      then pretrm_lat_rec m1 lp 17^ " \\rightarrow "^pretrm_lat_rec m2 16 rp
	  else "("^ pretrm_lat_rec m1 (-1) 17^ " \\rightarrow "^ pretrm_lat_rec m2 16 (-1)^ ")"	
  | PAp(PAp(PRevImplies,m2),m1) -> (* Use \\leftarrow ?*)
     if ((lp < 17) && (rp < 16)) 
     then pretrm_lat_rec m1 lp 17^ " \\rightarrow "^  pretrm_lat_rec m2 16 rp
	 else  "("^ pretrm_lat_rec m1 (-1) 17^" \\rightarrow "^ pretrm_lat_rec m2 16 (-1)^ ")"	
  | PAp(PAp(PAnd,m1),m2) ->
      if ((lp < 20) && (rp < 21)) 
      then pretrm_lat_rec m1  lp 20 ^ " \\wedge "^ pretrm_lat_rec m2  21 rp
	  else "("^ pretrm_lat_rec m1  (-1) 20^ " \\wedge "^ pretrm_lat_rec m2  21 (-1)^")"
  | PAp(PAp(POr,m1),m2) ->
      if ((lp < 18) && (rp < 19)) 
      then pretrm_lat_rec m1  lp 18^ " \\vee "^ pretrm_lat_rec m2  19 rp
	  else "("^ pretrm_lat_rec m1 (-1) 18^" \\vee "^pretrm_lat_rec m2  19 (-1)^ ")"
  | PAp(PAp(PIff,m1),m2) ->
      if ((lp < 14) && (rp < 14)) 
      then pretrm_lat_rec m1  lp 14^ " \\leftrightarrow "^ pretrm_lat_rec m2  14 rp
      else "("^pretrm_lat_rec m1 (-1) 14^" \\leftrightarrow "^ pretrm_lat_rec m2  14 (-1)^")"	
  | PAp(PAp(PEq,m1),m2) ->
      if ((lp < 40) && (rp < 40)) 
      then pretrm_lat_rec m1 lp 40^ " = "^ pretrm_lat_rec m2  40 rp
	  else "("^pretrm_lat_rec m1  (-1) 40^" = "^pretrm_lat_rec m2  40 (-1)^")"
  | PAp(PAp(PNEq,m1),m2) ->
       if ((lp < 40) && (rp < 40)) 
       then pretrm_lat_rec m1 lp 40^ " \\neq "^ pretrm_lat_rec m2  40 rp
	   else "("^ pretrm_lat_rec m1  (-1) 40^ " \\neq "^  pretrm_lat_rec m2  40 (-1)^ ")"
  | PAp(PAp(PNIff,m1),m2) ->
       if ((lp < 14) && (rp < 14)) 
       then pretrm_lat_rec m1  lp 14^" \\not \\leftrightarrow "^ pretrm_lat_rec m2  14 rp
	   else "("^ pretrm_lat_rec m1 (-1) 14^ " \\not \\leftrightarrow "^ pretrm_lat_rec m2  14 (-1)^ ")"
  | PAp(PAp(PNAnd,m1),m2) ->
      if (rp >= 30) 
      then "( \\neg ("^ pretrm_lat_rec m1  (-1) 20^ " \\wedge "^ pretrm_lat_rec m2  21 (-1)^ ") )"
      else  "\\neg ("^ pretrm_lat_rec m1  (-1) 20^" \\wedge "^pretrm_lat_rec m2  21 (-1)^")"
  | PAp(PAp(PNOr,m1),m2) ->
      if (rp >= 30) 
      then "( \\neg ("^pretrm_lat_rec m1  (-1) 20^ " \\vee "^ pretrm_lat_rec m2  21 (-1)^") )"
      else "\\neg ("^ pretrm_lat_rec m1  (-1) 20^ " \\vee "^ pretrm_lat_rec m2  21 (-1)^ ")"
  | PIff -> " \\leftrightarrow "
  | POr -> " \\vee "
  | PAnd -> " \\wedge " 
  | PNeg -> " \\neg "
  | PForall -> "(fun p => forall x, p x)" (* TODO when does this happen?*)
  | PExists -> "(fun p => exists x, p x)"
  | PAp(m1,m2) ->
      if ((lp < 5000) && (rp < 5001)) 
      then pretrm_lat_rec m1 lp 5000^" ~ "^ pretrm_lat_rec m2 5001 rp
	  else "("^ pretrm_lat_rec m1 (-1) 5000^" ~ "^pretrm_lat_rec m2  5001 (-1)^")"
  | PAr(m1,m2) ->
      if ((lp < 71) && (rp < 70)) 
      then pretrm_lat_rec m1  lp 71^ " \\rightarrow "^ pretrm_lat_rec m2  70 rp
	  else "("^ pretrm_lat_rec m1  (-1) 71^ " \\roghtarrow "^ pretrm_lat_rec m2  70 (-1)^ ")"
  | POf(n,p) -> "(" ^ (pretrm_lat_rec n (-1) (-1)) ^ " : " ^ (pretrm_lat_rec p (-1) (-1)) ^ ")" (* what is this?*)
(***  | PDef(n,p) -> print_pretrm_coq c n h hu lp rp ***)
  | PLam(xl,m) ->
	  if ((lp >= 0) || (rp >= 0)) 
      then  "( \\lambda "^ print_lam_lat xl m ^")"
      else  " \\lambda "^  print_lam_lat xl m 
  | PAll(xl,m) ->
	  if ((lp >= 0) || (rp >= 0)) 
      then  "( \\forall "^ print_all_lat xl m ^")"
	  else  " \\forall "^ print_all_lat xl m 
  | PEx(xl,m) ->    
	if ((lp >= 0) || (rp >= 0))
    then "(" ^print_ex_lat xl m  ^")"
    else print_ex_lat xl m
  | PChoice((x,xa),m) ->
	if ((lp >= 0) || (rp >= 0)) 
    then "(Sepsilon (fun "^ escaped x ^":"^pretrm_lat_rec xa (-1) (-1)^ 
      " => "^pretrm_lat_rec m (-1) (-1)^"))"
	else "Sepsilon (fun "^ escaped x ^":"^pretrm_lat_rec xa (-1) (-1)^
	  " => "^pretrm_lat_rec m (-1) (-1)^")"
  | _ -> raise (GenericSyntaxError ("Unknown pretrm case print Latex version : " ^ (pretrm_str m)))
and print_lam_lat xl m =
  match xl with
    ((x,a)::xr) ->
      begin
	" ("^ escaped x ^":"^pretrm_lat_rec a (-1) (-1)^")"^
	print_lam_lat xr m 
      end
  | [] ->
      begin
	 " => "^
	pretrm_lat_rec m (-1) (-1)
      end
and print_all_lat xl m =
  match xl with
    ((x,a)::xr) ->
      begin
	" ("^ escaped x ^":"^ pretrm_lat_rec a (-1) (-1)^")"^
	print_all_lat xr m 
      end
  | [] ->
      begin
	", "^ pretrm_lat_rec m (-1) (-1)
      end
and print_ex_lat xl m =
  match xl with
    ((x,a)::xr) ->
      begin
	 "\\exists"^ escaped x ^":"^ pretrm_lat_rec a (-1) (-1)^", "^
	print_ex_lat xr m
      end
  | [] ->
      begin
	pretrm_lat_rec m (-1) (-1)
      end
    
let pretrm_lat m = "$" ^pretrm_lat_rec m (-1) (-1) ^ "$"  
**)    