; Chad, Dec 14, 2010
(defun sex2thf (inf outf)
  (let ((i (open inf :direction :input))
	(o (open outf :direction :output :if-exists :supersede))
	(s nil))
    (loop while (setq s (read i nil nil)) do
	  (format o "~d~%" (st s)))
    (close i) (close o)))

(defun st (s)
  (if (stringp s)
      s
    (case (intern (car s))
	  (|thf| (format nil "thf(~d,~d,~d)."
			 (cadr s) (caddr s)
			 (st (cadddr s))))
	  (|:| (format nil "(~d : ~d)" (st (cadr s)) (st (caddr s))))
	  (|>| (format nil "(~d > ~d)" (st (cadr s)) (st (caddr s))))
	  (|=>| (format nil "(~d => ~d)" (st (cadr s)) (st (caddr s))))
	  (|<=| (format nil "(~d <= ~d)" (st (cadr s)) (st (caddr s))))
	  (|<=>| (format nil "(~d <=> ~d)" (st (cadr s)) (st (caddr s))))
	  (|<~>| (format nil "(~d <~~> ~d)" (st (cadr s)) (st (caddr s))))
	  (|~\|| (format nil "(~d ~~| ~d)" (st (cadr s)) (st (caddr s))))
	  (|~&| (format nil "(~d ~~& ~d)" (st (cadr s)) (st (caddr s))))
	  (|\||
	   (if (cddr s)
	       (format nil "(~d | ~d)" (st (cadr s)) (st (cons (car s) (cddr s))))
	     (cadr s)))
	  (|&|
	   (if (cddr s)
	       (format nil "(~d & ~d)" (st (cadr s)) (st (cons (car s) (cddr s))))
	     (cadr s)))
	  (|:=| (format nil "(~d := ~d)" (st (cadr s)) (st (caddr s))))
	  (|!=| (format nil "(~d != ~d)" (st (cadr s)) (st (caddr s))))
	  (|~| (format nil "(~~ @ ~d)" (st (cadr s))))
	  (|@| (format nil "(~d @ ~d)" (st (cadr s)) (st (caddr s))))
	  (|!| (format nil "(! [~d] : ~d)" (bndvars (cadr s)) (st (caddr s))))
	  (|?| (format nil "(? [~d] : ~d)" (bndvars (cadr s)) (st (caddr s))))
	  (|^| (format nil "(^ [~d] : ~d)" (bndvars (cadr s)) (st (caddr s))))
	  (|@+| (format nil "(@+ [~d] : ~d)" (bndvars (cadr s)) (st (caddr s))))
	  (t (error "Unhandled case ~d" s)))))

(defun bndvars (bl)
  (if (cdr bl)
      (format nil "~d : ~d , ~d" (cadar bl) (st (caddar bl)) (bndvars (cdr bl)))
    (format nil "~d : ~d" (cadar bl) (st (caddar bl)))))

