; Chad E Brown
; Aug 26 2010
; Classes of problems for PDL
; See:
; @INPROCEEDINGS{HustadtSchmidt2010,
;  AUTHOR        = {Hustadt, Ullrich and Schmidt, Renate A.},
;  TITLE         = {A Comparison of Solvers for Propositional Dynamic Logic},
;  BOOKTITLE     = {Proceedings of the Workshop on Practical Aspect of Automated Reasoning (PAAR-2010)},
;  YEAR          = {2010},
;  EDITOR        = {Konev, B. and Schmidt, Renate A. and Schulz, Stephan},
;  PAGES         = {},
;  CADDRESS      = {Edinburgh, Scotland},
;  CYEAR         = {2010},
;  CMONTH        = jul # {~14},
; }

(defun ref (bib)
  (case bib
	(HS2010
	 (format t "% Hustadt, Ullrich and Schmidt, Renate A.~%")
	 (format t "% A Comparison of Solvers for Propositional Dynamic Logic~%")
	 (format t "% Proceedings of the Workshop on Practical Aspect of Automated Reasoning (PAAR-2010)~%")
	 )
	(t (error "unknown bibitem ~d" bib))))

(defun pdl-preface (asinclude)
  (format t "% PDL definitions BEGIN~%")
  (if asinclude
      (format t "include('pdl.ax');~%")
    (let ((f (open "pdl.ax" :direction :input))
	  (l nil))
      (loop while (setq l (read-line f nil nil)) do
	    (format t "~d~%" l))
      ))
  (format t "% PDL definitions END~%"))

(defun declare-action (a)
  (format t "thf(~d,type,(~d : $i > $i > $o)).~%" a a))

(defun declare-prop (p)
  (format t "thf(~d,type,(~d : $i > $o)).~%" p p))

(defun declare-world (w)
  (format t "thf(~d,type,(~d : $i)).~%" w w))

; C1PDL:
(defun c1pdl (n k l)
  (unless (>= n k) (error "n = ~d < k = ~d" n k))
  (ref 'HS2010)
  (format t "% Parameter Values: n = ~d, k = ~d, l = ~d~%" n k l)
  (pdl-preface nil)
  (declare-action "a")
  (dotimes (i n) (declare-prop (format nil "p~d" (1+ i))))
  (declare-world "w")
  ; to do
  )

; C2PDL: