% Domain   : Syntactic
% Problem  : Skolem Property on two types
% English  : For every total relation r on a * b,
%            there is a corresponding function from a to b.
% Refs     : [Bro11] Brown (2011), Email to Geoff Sutcliffe
% Source   : [Bro11]
% Names    : CHOICE3 [Bro11]
% Status   : Theorem
% Comments : THF0 syntax
%          : This is similar to SYN996^1 and SYO508^1, but since we use two different types
%            there are fewer candidate instantiations.  Hence this version should be easier to solve.
thf(a,type,(a : $tType)).
thf(b,type,(b : $tType)).
thf(r,type,(r : (a > (b > $o)))).
thf(rtotal,axiom,(! [X : a] : (? [Y : b] : ((r @ X) @ Y)))).
thf(skolem,conjecture,(? [F : (a > b)] : (! [X : a] : ((r @ X) @ (F @ X))))).
