% Domain   : Syntactic
% Problem  : Property of case operator from ($o>$o) to $i defined from choice on $i
% Refs     : [Bro11] Brown (2011), Email to Geoff Sutcliffe
% Source   : [Bro11]
% Names    : CHOICE22c [Bro11]
% Status   : Theorem
% Comments : THF0 syntax
%          : A choice operator on $i is used to define an if-then-else operator at $i.
%            Check that case always returns one of the four given results.
thf(eps,type,(eps : (($i > $o) > $i))).
thf(choiceax,axiom,(! [P : ($i > $o)] : ((? [X : $i] : (P @ X)) => (P @ (eps @ P))))).
thf(caseoo,type,(case : (($o > $o) > ($i > ($i > ($i > ($i > $i))))))).
thf(caseood,definition,(case = (^ [B : ($o > $o), X : $i, Y : $i, U : $i, V : $i] : (eps @ (^ [Z : $i] : (((B = (^ [A : $o] : $false)) & (Z = X)) | ((B = ~) & (Z = Y)) | ((B = (^ [A : $o] : A)) & (Z = U)) | ((B = (^ [A : $o] : $true)) & (Z = V)))))))).
thf(f,type,(f : ($o > $o))).
thf(conj,conjecture,(! [X : $i] : ((((((case @ f) @ X) @ X) @ X) @ X) = X))).
  



