% Domain   : Syntactic
% Problem  : Case operator from ($o>$o) to $i defined from choice on $i
% Refs     : [Bro11] Brown (2011), Email to Geoff Sutcliffe
% Source   : [Bro11]
% Names    : CHOICE15 [Bro11]
% Status   : Theorem
% Comments : THF0 syntax
%          : A case operator from ($o>$o) (with 4 elements) to $i is defined using a choice operator on $i.
%            Check all 4 equations.
thf(eps,type,(eps : (($i > $o) > $i))).
thf(choiceax,axiom,(! [P : ($i > $o)] : ((? [X : $i] : (P @ X)) => (P @ (eps @ P))))).
thf(caseoo,type,(case : (($o > $o) > ($i > ($i > ($i > ($i > $i))))))).
thf(caseood,definition,(case = (^ [B : ($o > $o), X : $i, Y : $i, U : $i, V : $i] : (eps @ (^ [Z : $i] : (((B = (^ [A : $o] : $false)) & (Z = X)) | ((B = ~) & (Z = Y)) | ((B = (^ [A : $o] : A)) & (Z = U)) | ((B = (^ [A : $o] : $true)) & (Z = V)))))))).
thf(f0,type,(f0 : ($o > $o))).
thf(f0f,axiom,((f0 @ $false) = $false)).
thf(f0t,axiom,((f0 @ $true) = $false)).
thf(f1,type,(f1 : ($o > $o))).
thf(f1f,axiom,((f1 @ $false) = $true)).
thf(f1t,axiom,((f1 @ $true) = $false)).
thf(f2,type,(f2 : ($o > $o))).
thf(f2f,axiom,((f2 @ $false) = $false)).
thf(f2t,axiom,((f2 @ $true) = $true)).
thf(f3,type,(f3 : ($o > $o))).
thf(f3f,axiom,((f3 @ $false) = $true)).
thf(f3t,axiom,((f3 @ $true) = $true)).
thf(conj,conjecture,(! [X : $i, Y : $i, U : $i, V : $i] : (((((((case @ f0) @ X) @ Y) @ U) @ V) = X) & ((((((case @ f1) @ X) @ Y) @ U) @ V) = Y) & ((((((case @ f2) @ X) @ Y) @ U) @ V) = U) & ((((((case @ f3) @ X) @ Y) @ U) @ V) = V)))).
