% Domain   : Syntactic
% Problem  : If-then-else on $i>$i defined from choice on $i>$i
% Refs     : [Bro11] Brown (2011), Email to Geoff Sutcliffe
% Source   : [Bro11]
% Names    : CHOICE16 [Bro11]
% Status   : Theorem
% Comments : THF0 syntax
%          : A case operator from oo (with 4 elements) to i is defined using a choice operator on i.
%            Check constant false equation.
%            Difficulty: Easy
thf(eps,type,(eps : (($i > $o) > $i))).
thf(choiceax,axiom,(! [P : ($i > $o)] : ((? [X : $i] : (P @ X)) => (P @ (eps @ P))))).
thf(caseoo,type,(case : (($o > $o) > ($i > ($i > ($i > ($i > $i))))))).
thf(caseood,definition,(case = (^ [B : ($o > $o), X : $i, Y : $i, U : $i, V : $i] : (eps @ (^ [Z : $i] : (((B = (^ [A : $o] : $false)) & (Z = X)) | ((B = ~) & (Z = Y)) | ((B = (^ [A : $o] : A)) & (Z = U)) | ((B = (^ [A : $o] : $true)) & (Z = V)))))))).
thf(f,type,(f : ($o > $o))).
thf(ff,axiom,((f @ $false) = $false)).
thf(ft,axiom,((f @ $true) = $false)).
thf(conj,conjecture,(! [X : $i, Y : $i, U : $i, V : $i] : ((((((case @ f) @ X) @ Y) @ U) @ V) = X))).



