% Domain   : Syntactic
% Problem  : Property of if-then-else on $i defined from choice on $i
% Refs     : [Bro11] Brown (2011), Email to Geoff Sutcliffe
% Source   : [Bro11]
% Names    : CHOICE15c [Bro11]
% Status   : Theorem
% Comments : THF0 syntax
%          : A choice operator on $i is used to define an if-then-else operator at $i.
%            Check that if the then-part and the else-part are both X, it returns X.
thf(eps,type,(eps : (($i > $o) > $i))).
thf(choiceax,axiom,(! [P : ($i > $o)] : ((? [X : $i] : (P @ X)) => (P @ (eps @ P))))).
thf(if,type,(if : ($o > ($i > ($i > $i))))).
thf(ifd,definition,(if = (^ [B : $o, X : $i, Y : $i] : (eps @ (^ [Z : $i] : ((B & (Z = X)) | ((~ (B)) & (Z = Y)))))))).
thf(conj,conjecture,(! [B : $o, X : $i] : ((((if @ B) @ X) @ X) = X))).


