% Domain   : Syntactic
% Problem  : Range of if-then-else on $i defined from choice on $i
% Refs     : [Bro11] Brown (2011), Email to Geoff Sutcliffe
% Source   : [Bro11]
% Names    : CHOICE15b [Bro11]
% Status   : Theorem
% Comments : THF0 syntax
%          : A choice operator on $i is used to define an if-then-else operator at $i.
%            Check that it always returns the then-part or the else-part.
thf(eps,type,(eps : (($i > $o) > $i))).
thf(choiceax,axiom,(! [P : ($i > $o)] : ((? [X : $i] : (P @ X)) => (P @ (eps @ P))))).
thf(if,type,(if : ($o > ($i > ($i > $i))))).
thf(ifd,definition,(if = (^ [B : $o, X : $i, Y : $i] : (eps @ (^ [Z : $i] : ((B & (Z = X)) | ((~ (B)) & (Z = Y)))))))).
thf(conj,conjecture,(! [B : $o, X : $i, Y : $i] : (((((if @ B) @ X) @ Y) = X) | ((((if @ B) @ X) @ Y) = Y)))).


