% Domain   : Syntactic
% Problem  : If-then-else on $i defined from choice on $i
% Refs     : [Bro11] Brown (2011), Email to Geoff Sutcliffe
% Source   : [Bro11]
% Names    : CHOICE15 [Bro11]
% Status   : Theorem
% Comments : THF0 syntax
%          : A choice operator on $i is used to define an if-then-else operator at $i.
%            Check that it works.
thf(eps,type,(eps : (($i > $o) > $i))).
thf(choiceax,axiom,(! [P : ($i > $o)] : ((? [X : $i] : (P @ X)) => (P @ (eps @ P))))).
thf(if,type,(if : ($o > ($i > ($i > $i))))).
thf(ifd,definition,(if = (^ [B : $o, X : $i, Y : $i] : (eps @ (^ [Z : $i] : ((B & (Z = X)) | ((~ (B)) & (Z = Y)))))))).
thf(conj,conjecture,(! [X : $i, Y : $i] : (((((if @ $true) @ X) @ Y) = X) & ((((if @ $false) @ X) @ Y) = Y)))).


