% Domain   : Syntactic
% Problem  : Binary choice on individuals 4
% English  : There is an Epsa such that
%            Epsa and (epsb Epsa) work together to give an a and b such that R a b holds,
%            if such an a and b exist for a binary relation R on $i.
% Refs     : [Bac10] Backes (2010), Tableaux for Higher-Order Logic with
%            If-Then-Else, Description and Choice. (Master's Thesis)
%          : [Bro11] Brown (2011), Email to Geoff Sutcliffe
% Source   : Section 7.1 of [Bac10]
% Names    : CHOICE10 [Bro11]
% Status   : Theorem
% Comments : THF0 syntax
%          : A choice operator on i can be used to define a choice operator on i*i (Curried).
%            In this version, the prover must synthesize both parts of the solution.
%            Difficulty: Very Hard
thf(conj,conjecture,(? [Epsa : (($i > ($i > $o)) > $i), Epsb : (($i > ($i > $o)) > $i)] :
    (! [R : ($i > ($i > $o))] : ((? [X : $i, Y : $i] : ((R @ X) @ Y)) => ((R @ (Epsa @ R)) @ (Epsb @ R)))))).

