; code for debugging
(defvar *debuglevel* 0)

(defun get-wff (m)
  (cond ((lam-p m) (lam (get-tp (lam-dom m)) (get-wff (lam-body m))))
	((ap-p m) (ap (get-wff (ap-f m)) (get-wff (ap-a m))))
	((evar-p m) (evar (cadar m) (mapcar #'get-wff (cddar m))))
	((equal m *NEG*) *NEG*)
	((equal m *AND*) *AND*)
	((equal m *OR*) *OR*)
	((equal m *EQUIV*) *EQUIV*)
	((equal m *IMPLIES*) *IMPLIES*)
	((equal m *FALSE*) *FALSE*)
	((equal m *TRUE*) *TRUE*)
	(t
	 (if (consp (car m))
	     (case (caar m)
		   (SIG (lsig (cdar m)))
		   (PI (lpi (cdar m)))
		   (CHOOSE (lepsilon (cdar m)))
		   (EQ (leq (cdar m)))
		   (t (setq *m* m) (break)))
	   (if (numberp (car m))
	       (db2 m)
	     (if (symbolp (car m))
		 (get (car m) 'consth)
	       (progn (setq *m* m) (break))))))))

(defun get-tp (m)
  (if (consp m)
      (ar (get-tp (car m)) (get-tp (cdr m)))
    m))
