; location of Satallax directory (assumes you are in this directory when loading make.lisp)
(defvar *satallax-dir* (truename "."))
; location of minisat binary that should be compiled before Satallax.
(defvar *minisat-binary* (format nil "~dminisat/simp/minisat_static" *satallax-dir*))
; Or, use your own copy of minisat:
(when (probe-file "config.lisp") (load "config.lisp"))
; Look for minisat binary
(unless (probe-file *minisat-binary*)
  (setq *minisat-binary* (format nil "~dminisat/simp/minisat_release" *satallax-dir*))
  (unless (probe-file *minisat-binary*)
    (setq *minisat-binary* (format nil "~dminisat/core/minisat_static" *satallax-dir*))
    (unless (probe-file *minisat-binary*)
      (setq *minisat-binary* (format nil "~dminisat/core/minisat_release" *satallax-dir*)))))
(compile-file "src/hol2sat-code.lisp" :output-file "../tmp/")
(load "tmp/hol2sat-code.fasl")
(delete-file "tmp/hol2sat-code.fasl")
(compile-file "src/satallax.lisp" :output-file "../tmp/")
(load "tmp/satallax.fasl")
(delete-file "tmp/satallax.fasl")

(if (probe-file "version.lisp") (load "version.lisp") (defun satallax-version () (format t "Satallax (Version Unknown, Sorry)~%")))

(unless (probe-file *minisat-binary*)
  (format t "*** Cannot find MiniSat executable. ***~%")
  (format t "To build MiniSat, try this:~%cd minisat~%cat README~%cd simp [recommended] or cd core [alternative]~%gmake rs or make rs [recommended] or gmake r or make r [alternatives]~%")
  (format t "*** Building Satallax, but you will need to always provide the location of MiniSat with the -M option. ***~%")
  (format t "It is recommended that you either build MiniSat or (if you have MiniSat) create a config.lisp file with the line~%")
  (format t "(setq *minisat-binary* (format nil \"<path to MiniSat Binary>\"))~%")
  (format t "and then rebuild Satallax.~%")
  )

#+:sbcl
(sb-ext:save-lisp-and-die "bin/satallax" :executable t :toplevel #'satallax-top)

