; code for debugging
(defvar *debuglevel* 0)

(defun tp-str (a)
  (if (consp a)
      (format nil "(~d > ~d)" (tp-str (car a)) (tp-str (cdr a)))
    (format nil "~d" a)))
  
(defun wff-str (m &optional names)
  (if (ap-p m)
      (cond ((neg-p m)
	     (format nil "(~~ ~d)" (wff-str (ap-a m) names))
	     )
	    ((and-p m)
	     (format nil "(~d & ~d)" (wff-str (bin-l m) names) (wff-str (bin-r m) names))
	     )
	    ((eqn-p m)
	     (format nil "(~d = ~d)" (wff-str (bin-l m) names) (wff-str (bin-r m) names))
	     )
	    ((all-p m)
	     (format nil "(! ~d)" (wff-str (ap-a m) names)))
	    (t
	     (format nil "(~d ~d)" (wff-str (ap-f m) names) (wff-str (ap-a m) names))))
    (if (lam-p m)
	(let ((x (format nil "x~d" (length names))))
	  (format nil "(\\~d:~d.~d)" x (tp-str (lam-dom m)) (wff-str (lam-body m) (cons x names))))
      (if (pi-p m)
	  "!"
	(if (sig-p m)
	    "?"
	  (if (choiceop-p m)
	      "@+"
	    (if (evar-p m)
		(format nil "~d[~d]" (cadar m)
			(esub-str (cddar m) names))
	      (if (numberp (car m))
		  (or 
		   (nth (car m) names)
		   (format nil "{~d}" (- (car m) (length names))))
		(format nil "~d" (car m))))))))))

(defun esub-str (sub names)
  (if sub
      (if (cdr sub)
	  (format nil "~d,~d"
		  (wff-str (car sub) names)
		  (esub-str (cdr sub) names))
	(wff-str (car sub) names))
    ""))

(defun get-wff (m)
  (cond ((lam-p m) (lam (get-tp (lam-dom m)) (get-wff (lam-body m))))
	((ap-p m) (ap (get-wff (ap-f m)) (get-wff (ap-a m))))
	((evar-p m) (evar (cadar m) (mapcar #'get-wff (cddar m))))
	((equal m *NEG*) *NEG*)
	((equal m *AND*) *AND*)
	((equal m *OR*) *OR*)
	((equal m *EQUIV*) *EQUIV*)
	((equal m *IMPLIES*) *IMPLIES*)
	((equal m *FALSE*) *FALSE*)
	((equal m *TRUE*) *TRUE*)
	(t
	 (if (consp (car m))
	     (case (caar m)
		   (SIG (lsig (cdar m)))
		   (PI (lpi (cdar m)))
		   (CHOOSE (lepsilon (cdar m)))
		   (EQ (leq (cdar m)))
		   (t (setq *m* m) (break)))
	   (if (numberp (car m))
	       (db2 m)
	     (if (symbolp (car m))
		 (get (car m) 'consth)
	       (progn (setq *m* m) (break))))))))

(defun get-tp (m)
  (if (consp m)
      (ar (get-tp (car m)) (get-tp (cdr m)))
    m))
